import { HistoryDataConverter } from './HistoryDataConverter';
/**
 * 履歴を管理する。<BR>
 * @since 　2002/12/20
 * @author　Kawae
 * @version 2002/12/20
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
export declare class History<E, H> {
    /**
     * 保存する履歴の最大数 **/
    protected _maxHistoryNum: number;
    protected _history: H[];
    protected _current: H;
    protected _converter: HistoryDataConverter<E, H>;
    /**
     * 指定された数の履歴を保存する新たな履歴を構築する。
     * @param hisnum	履歴の最大保存数
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    constructor(hisnum: number, converter: HistoryDataConverter<E, H>);
    /**
     * 指定された数を、履歴の最大保存数として設定する。
     * @param num	履歴の最大保存数
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
     * @throws IllegalArgumentException
    **/
    setMaxHistory(num: number): void;
    /**
     * 現在、設定されている履歴の最大保存数を返す。
     * @return	履歴の最大保存数
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getMaxHistory(): number;
    /**
     * 現在、保存されているすべての履歴を削除する。
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    flushHistory(): void;
    /**
     * 現在、保存されている履歴を数を返す。
     * @return 履歴の数
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getHistorySize(): number;
    /**
     * 新たに履歴を追加する。
     * 保存している履歴の数が、履歴の最大保存数を超えた場合、
     * 古い履歴は、順次削除される。
     * @param o 追加する履歴
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    addHistory(o: E): void;
    /**
     * 保存されている履歴からアンドゥを行えるか否か判定する。
     * 保存されている履歴が１つ以上存在する、かつ前回のアンドゥ、
     * またはリドゥなどで処理された履歴が、最古の履歴でない場合のみ
     * アンドゥ可能となる。
     * @return アンドゥできる場合、true。できない場合は、false
     * @since   2010/04/08
     * @author  Kawae
    **/
    hasUndo(): boolean;
    /**
     * 保存されている履歴からリドゥを行えるか否か判定する。
     * 保存されている履歴が１つ以上存在する、かつ前回のアンドゥ、
     * またはリドゥなどで処理された履歴が、最新の履歴でない場合のみ
     * リドゥ可能となる。
     * @return リドゥできる場合、true。できない場合は、false
     * @since   2010/04/08
     * @author  Kawae
     * @version 2002/12/20
    **/
    hasRedo(): boolean;
    /**
     * 現在、保存されている履歴から最新の履歴を返す。
     * @return 最新の履歴。履歴が存在しない場合は、null
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getLastHistory(): H;
    /**
     * 現在の履歴を返す。
     * @return 現在の履歴。
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getCurrentHistory(): H;
    /**
     * 現在の履歴の１世代前の履歴を返す。
     * @return １世代前の履歴。
     * @see #redo()
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    undo(): E;
    /**
     * 現在の履歴の１世代後の履歴を返す。
     * @return １世代後の履歴。
     * @see #undo()
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    redo(): E;
    getConverter(): HistoryDataConverter<E, H>;
}
