var emutils = require('emutils');
var StringBuilder = (function () {
    function StringBuilder(str) {
        this.str = str || "";
    }
    StringBuilder.prototype.append = function (s) {
        if (typeof s === "string")
            this.str += s;
        else if (typeof s === "number") {
            if (Math.floor(s) === s)
                this.str += s.toString();
            else
                this.str += s.toFixed(4);
        }
        else {
            throw Error(typeof s);
        }
        return this;
    };
    StringBuilder.prototype.toString = function () {
        return this.str;
    };
    return StringBuilder;
})();
exports.StringBuilder = StringBuilder;
var MyPrintStream = (function () {
    function MyPrintStream() {
        this.size = 0;
        this.lines = [];
    }
    MyPrintStream.prototype.println = function (line) {
        this.lines.push(line);
    };
    MyPrintStream.prototype.close = function () {
    };
    MyPrintStream.prototype.getData = function () {
        var str = this.lines.join("\n");
        var buf = new ArrayBuffer(emutils.lengthBytesUTF8(str));
        var bytes = new Uint8Array(buf);
        emutils.stringToUTF8Array(str, bytes, 0, bytes.length);
        return bytes;
    };
    return MyPrintStream;
})();
exports.MyPrintStream = MyPrintStream;
//# sourceMappingURL=util.js.map