import { KColor } from '../kwt/KColor';
import { KPoint2d } from '../vecmath/KPoint2d';
import { KArea } from '../kwt/KArea';
import { KFill } from '../kwt/KFill';
import { KImage } from '../kwt/KImage';
import { IRichGraphics } from '../kwt/IRichGraphics';
import { KLineType } from '../kwt/KLineType';
import { KLocalAxis } from '../geom/KLocalAxis';
import { K2DPathFigurePoint } from '../geom/K2DPathFigurePoint';
import { K2DPathFigureLine } from '../geom/K2DPathFigureLine';
import { PdfGraphics } from './PdfGraphics';
import { StringBuilder } from './util';
/**
 * IRichGraphics を使用して、PdfCommandGraphics への描画を行うアダプタ。
 * @since		2005/02/23
 * @author		fujita
 * @version	2005/02/23Copyright (c) 2005 KITec Inc,.. All rights reserved.
**/
export declare class PdfRichGraphicsAdapter implements IRichGraphics {
    /**
     * ポリゴン等の描画用のバッファのサイズ **/
    static BUF_SIZE: number;
    /**
     * ポリゴン等の描画用の x 座標のバッファ **/
    private XBUF;
    /**
     * ポリゴン等の描画用の y 座標のバッファ **/
    private YBUF;
    /**
     * 線の属性が指定されていない（null）の場合の線種 **/
    static NULL_LINE: KLineType;
    static EPS: number;
    static D2R: number;
    /**
     * PDF グラフィックス **/
    mGraphics: PdfGraphics;
    /**
     * 描画スケール **/
    mScale: number;
    /**
     * デフォルトの内容を持つ新たな PdfRichGraphicsAdapter を作成する。
     * @param g	PDF グラフィックス
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    constructor(g: PdfGraphics);
    scale(scale: number): void;
    getScale(): number;
    /**
     * 指定された flag により、フォントをファイルに 埋め込むかどうかを指定する。
     * @param flag	フォントを埋め込む場合、true。そうでない場合は、false
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    setFontEmbed(flag: boolean): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#setClipArea(double,double,double,double)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    setClipArea(x1: number, y1: number, x2: number, y2: number): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#releaseClipArea()
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    releaseClipArea(): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#setColor(java.awt.Color)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    setColor(c: KFill): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawLine(double,double,double,double,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawLine(x1: number, y1: number, x2: number, y2: number, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawCircle(double,double,double,double,double,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawCircle(xc1: number, yc1: number, ra: number, ss: number, ee: number, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawFillCircle(double,double,double,double,double,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawFillCircle(xc1: number, yc1: number, ra: number, ss: number, ee: number, lt: KLineType): void;
    /**
     * 指定された内容をもとに、楕円の弧を描く。
     * @param xc1		楕円中心の x 座標
     * @param yc1		楕円中心の y 座標
     * @param v		楕円の幅
     * @param h		楕円の高さ
     * @param ss		楕円の開始角度[°]
     * @param ee		楕円の終了角度[°]
     * @param lt		線種
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawEllipse(xc1: number, yc1: number, v: number, h: number, ss: number, ee: number, lt: KLineType): void;
    /**
     * 指定された内容をもとに、楕円の弧を描き、 その内部を塗りつぶす。
     * @param xc1		楕円中心の x 座標
     * @param yc1		楕円中心の y 座標
     * @param v		楕円の幅
     * @param h		楕円の高さ
     * @param ss		楕円の開始角度[°]
     * @param ee		楕円の終了角度[°]
     * @param lt		線種
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawFillEllipse(xc1: number, yc1: number, v: number, h: number, ss: number, ee: number, lt: KLineType): void;
    /**
     * 指定された内容をもとに、楕円の弧を描く。
     * @param xc1		楕円中心の x 座標
     * @param yc1		楕円中心の y 座標
     * @param v		楕円の幅
     * @param h		楕円の高さ
     * @param ss		楕円の開始角度[°]
     * @param ee		楕円の終了角度[°]
     * @param lt		線種
     * @param fill	楕円を塗りつぶす場合、true。そうでない場合は、false
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    private drawEllipse_(xc1, yc1, v, h, ss, ee, lt, fill);
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawRect(double,double,double,double,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawRect(x1: number, y1: number, x2: number, y2: number, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawFillRect(double,double,double,double,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawFillRect(x1: number, y1: number, x2: number, y2: number, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawRoundRect(double,double,double,double,double,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawRoundRect(x1: number, y1: number, x2: number, y2: number, round: number, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawFillRoundRect(double,double,double,double,double,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawFillRoundRect(x1: number, y1: number, x2: number, y2: number, round: number, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawPolygon(com.kt.util.RefList,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawPolygon(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawFillPolygon(com.kt.util.RefList,jp.kitec.kwt.KLineType)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawFillPolygon(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawPolyLine(com.kt.util.RefList,jp.kitec.kwt.KLineType)
     * @since		2005/02/23
     * @author		fujita
     * @version	2005/02/23
    **/
    drawPolyLine(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawImage(java.awt.Image,java.lang.String,double,double,double,double)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawImageId(img: KImage, id: string, x1: number, y1: number, x2: number, y2: number): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawImage(java.awt.Image,double,double,double,double)
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    drawImagePosition(img: KImage, x1: number, y1: number, x2: number, y2: number): void;
    drawImageRect(img: KImage, cx: number, cy: number, width: number, height: number, angle: number): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawText(java.lang.String,double,double,java.lang.String,int,double,double)
     * @since		2004/09/29
     * @author		kawae
     * @version	2005/02/23	fujita文字の回転を反映するよう変更。
    **/
    drawText(s: string, x1: number, y1: number, fontname: string, fonttype: number, size: number, angle: number): void;
    /**
     * 線種を設定する。
     * @param lt	線種
     * @since		2004/09/29
     * @author		kawae
     * @version	2004/09/29
    **/
    setLineType(lt: KLineType): void;
    /**
     * コレクションノードを配列に直す
     * @param pts
     * @author kawae
     * @since 2004/09/29
    **/
    createFloatPointArrayBuffer(pts: Array<K2DPathFigurePoint>): void;
    /**
     * @see jp.kitec.kwt.IRichGraphics#drawImage(java.awt.Image,java.lang.String,java.lang.String,double,double,double,double)
     * @param img
     * @param prefix
     * @param id
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     * @since 2006/01/24
     * @author kamimura
     * @version 2006/01/24
    **/
    drawImagePrefixId(img: KImage, prefix: string, id: string, x1: number, y1: number, x2: number, y2: number): void;
    /**
     * 描画パス **/
    mWindingRule: number;
    mCurrentPoint: KPoint2d;
    pdfPathMode: boolean;
    pathInit(i: number): void;
    pathClear(): void;
    pathMoveTo(x: number, y: number, la: KLocalAxis): void;
    pathLineTo(x: number, y: number, la: KLocalAxis): void;
    pathQuadTo(x1: number, y1: number, x2: number, y2: number, la: KLocalAxis): void;
    pathCurveTo(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, la: KLocalAxis): void;
    getGlobalX(x: number, y: number, la: KLocalAxis): number;
    getGlobalY(x: number, y: number, la: KLocalAxis): number;
    appendPoint(sb: StringBuilder, x: number, y: number): void;
    pathClose(): void;
    pathAdd(col: Array<K2DPathFigureLine>, la: KLocalAxis): void;
    pathArc(cx: number, cy: number, r: number, h: number, startAngle: number, arcAngle: number, la: KLocalAxis): void;
    fillPath(lt: KLineType): void;
    updateCurrentPoint(xx: number, yy: number): void;
    drawPath(lt: KLineType): void;
    shadePath(lt: KLineType, x1: number, y1: number, x2: number, y2: number, c1: KColor, c2: KColor, cyclic: boolean): void;
    drawMark(x: number, y: number, r: number, type: number): void;
    getDrawArea(): KArea;
    getDotPerLen(): number;
    setQuality(quality: boolean): void;
    getQuality(): boolean;
}
