var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var PdfCommand_1 = require('./PdfCommand');
var PdfRichGraphicsAdapter_1 = require('./PdfRichGraphicsAdapter');
//module option.pdf
/**
 * @author kawae
 * @since 2004/11/09
**/
var PdfRichGraphics = (function (_super) {
    __extends(PdfRichGraphics, _super);
    function PdfRichGraphics(file) {
        _super.call(this, null);
        this.pdf = new PdfCommand_1.PdfCommand(file);
    }
    //public constructor(file: string, code?: string) {
    //    super(null);
    //    this.pdf = new PdfCommand(file);
    //}
    PdfRichGraphics.prototype.setFontEmbed = function (flag) {
        this.mFontEmbed = flag;
    };
    PdfRichGraphics.prototype.startPage = function (size, direction) {
        this.pdf.setPageInfo(size, direction);
        this.pdf.setUserCoordinateDirectionY(PdfCommand_1.PdfCommand.BOTTOM_TO_TOP);
        this.mGraphics = this.pdf.getGraphics();
        this.mGraphics.setFontEmbed(this.mFontEmbed);
    };
    PdfRichGraphics.prototype.endPage = function () {
        this.mGraphics.dispose();
    };
    return PdfRichGraphics;
})(PdfRichGraphicsAdapter_1.PdfRichGraphicsAdapter);
exports.PdfRichGraphics = PdfRichGraphics;
//# sourceMappingURL=PdfRichGraphics.js.map