var KArea_1 = require('./KArea');
//module jp.kitec.kwt
/**
 * キャンバス等のビューポート**/
var KViewPort = (function () {
    /**
     * コンストラクタ
     * @param viewname
     * @author kawae
     * @since 2004/10/02
    **/
    function KViewPort(viewname) {
        if (viewname === void 0) { viewname = ""; }
        this.x1 = this.y1 = this.x2 = this.y2 = 0;
        this.mViewName = viewname;
    }
    /**
     * ビューの名前の設定
     * @param s
     * @author kawae
     * @since 2004/10/02
    **/
    KViewPort.prototype.setViewPortName = function (s) {
        this.mViewName = s;
    };
    /**
     * ビューの名前の取得
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    KViewPort.prototype.getViewPortName = function () {
        return this.mViewName;
    };
    KViewPort.prototype.getX1 = function () {
        return this.x1;
    };
    KViewPort.prototype.setX1 = function (x1) {
        this.x1 = x1;
    };
    KViewPort.prototype.getY1 = function () {
        return this.y1;
    };
    KViewPort.prototype.setY1 = function (y1) {
        this.y1 = y1;
    };
    KViewPort.prototype.getX2 = function () {
        return this.x2;
    };
    KViewPort.prototype.setX2 = function (x2) {
        this.x2 = x2;
    };
    KViewPort.prototype.getY2 = function () {
        return this.y2;
    };
    KViewPort.prototype.setY2 = function (y2) {
        this.y2 = y2;
    };
    /**
     * 表示中心 **/
    KViewPort.prototype.getCx = function () {
        return (this.x1 + this.x2) / 2;
    };
    KViewPort.prototype.getCy = function () {
        return (this.y1 + this.y2) / 2;
    };
    KViewPort.prototype.getCopy = function () {
        var vp = new KViewPort(this.mViewName);
        vp.x1 = this.x1;
        vp.y1 = this.y1;
        vp.x2 = this.x2;
        vp.y2 = this.y2;
        return vp;
    };
    KViewPort.prototype.setViewPort = function (vp) {
        this.x1 = vp.x1;
        this.y1 = vp.y1;
        this.x2 = vp.x2;
        this.y2 = vp.y2;
    };
    KViewPort.prototype.resetViewPort = function (minxOrArea, minyOrMargin, maxx, maxy, margin) {
        if (minxOrArea instanceof KArea_1.KArea) {
            var area = minxOrArea;
            margin = minyOrMargin;
            this.x1 = area.minX - margin;
            this.y1 = area.minY - margin;
            this.x2 = area.maxX + margin;
            this.y2 = area.maxY + margin;
        }
        else {
            if (typeof minxOrArea !== "number" || typeof minyOrMargin !== "number")
                throw new Error();
            var minx = minxOrArea;
            var miny = minyOrMargin;
            this.x1 = minx - margin;
            this.y1 = miny - margin;
            this.x2 = maxx + margin;
            this.y2 = maxy + margin;
        }
    };
    /**
     * 画面中心の移動
     * @param cx
     * @param cy
    **/
    KViewPort.prototype.setViewCenter = function (cx, cy) {
        var offsetx = cx - this.getCx();
        var offsety = cy - this.getCy();
        this.x1 += offsetx;
        this.x2 += offsetx;
        this.y1 += offsety;
        this.y2 += offsety;
    };
    KViewPort.prototype.dotPerLen = function (d) {
        var ww = d.width / (this.x2 - this.x1);
        var wh = d.height / (this.y2 - this.y1);
        return ww < wh ? ww : wh;
    };
    /**
     * 実座標から画面座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   実座標値
     * @return  デバイス座標値
    **/
    KViewPort.prototype.realToDevX = function (d, x) {
        return Math.round(this.realToDevXd(d, x));
    };
    /**
     * 実座標から画面座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   実座標値
     * @return  デバイス座標値
    **/
    KViewPort.prototype.realToDevY = function (d, y) {
        return Math.round(this.realToDevYd(d, y));
    };
    /**
     * 実座標から画面座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   実座標値
     * @return  デバイス座標値
    **/
    KViewPort.prototype.realToDevXd = function (d, x) {
        return (x - this.getCx()) * this.dotPerLen(d) + d.width / 2.0;
    };
    /**
     * 実座標から画面座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   実座標値
     * @return  デバイス座標値
    **/
    KViewPort.prototype.realToDevYd = function (d, y) {
        return d.height - ((y - this.getCy()) * this.dotPerLen(d) + d.height / 2.0);
    };
    /**
     * 画面座標から実座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   デバイス座標値
     * @return      実座標値
    **/
    KViewPort.prototype.devToRealX = function (d, x) {
        return (x - d.width / 2.0) / this.dotPerLen(d) + this.getCx();
    };
    /**
     * 画面座標から実座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   デバイス座標値
     * @return      実座標値
    **/
    KViewPort.prototype.devToRealY = function (d, y) {
        return (d.height / 2.0 - y) / this.dotPerLen(d) + this.getCy();
    };
    return KViewPort;
})();
exports.KViewPort = KViewPort;
//# sourceMappingURL=KViewPort.js.map