var KRuntime_1 = require('./KRuntime');
//module jp.kitec.kwt
/**
 * @author kawae
 **/
var KFont = (function () {
    function KFont(fontname, fonttype, fontsize) {
        this.mFontname = fontname;
        this.mFonttype = fonttype | 0;
        this.mFontsize = fontsize | 0;
    }
    KFont.prototype.name = function () {
        return this.mFontname;
    };
    KFont.prototype.style = function () {
        return this.mFonttype;
    };
    KFont.prototype.size = function () {
        return this.mFontsize;
    };
    KFont.prototype.ascent = function () {
        return this.getFontMetrics(null).getAscent();
    };
    KFont.prototype.descent = function () {
        return this.getFontMetrics(null).getDescent();
    };
    KFont.prototype.height = function () {
        return this.getFontMetrics(null).getHeight();
    };
    KFont.prototype.stringWidth = function (s) {
        return this.getFontMetrics(null).stringWidth(s);
    };
    /**
     * 現在の Font オブジェクトを複製し新しいサイズを適用することにより、新しい Font オブジェクトを生成します。
     * @param size
     * @return
    **/
    KFont.prototype.deriveSize = function (size) {
        return KRuntime_1.KRuntime.runtime().getFont(this.mFontname, this.mFonttype, size);
    };
    /**
     * 現在の Font オブジェクトを複製し新しいスタイルを適用することにより、新しい Font オブジェクトを生成します。
     * @param style
     * @return
    **/
    KFont.prototype.deriveStyle = function (style) {
        return KRuntime_1.KRuntime.runtime().getFont(this.mFontname, style, this.mFontsize);
    };
    /**
     * この Font オブジェクトを複製し新しいスタイルおよびサイズを適用することにより、新しい Font オブジェクトを生成します。
     * @param style
     * @param size
     * @return
    **/
    KFont.prototype.deriveStyleSize = function (style, size) {
        return KRuntime_1.KRuntime.runtime().getFont(this.mFontname, style, size);
    };
    KFont.prototype.hashCode = function () {
        var prime = 31;
        var result = 1;
        //result = prime * result + ((this.mFontname == null) ? 0 : this.mFontname.hashCode());
        result = prime * result + (this.mFontsize);
        result = prime * result + this.mFonttype;
        return result;
    };
    KFont.prototype.equals = function (obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this.mFontname == null) {
            if (other.mFontname != null)
                return false;
        }
        else if (this.mFontname !== other.mFontname)
            return false;
        if (this.mFontsize !== other.mFontsize)
            return false;
        if (this.mFonttype != other.mFonttype)
            return false;
        return true;
    };
    KFont.getFont = function (fontname, fontstyle, fontsize) {
        return KRuntime_1.KRuntime.runtime().getFont(fontname, fontstyle, fontsize);
    };
    /**
     * フォントタイプ**/
    KFont.PLAIN = 0;
    KFont.BOLD = 1;
    KFont.ITALIC = 2;
    return KFont;
})();
exports.KFont = KFont;
//# sourceMappingURL=KFont.js.map