import { KArea } from './KArea';
import { KDimension } from './KDimension';
import { KFill } from './KFill';
import { KImage } from './KImage';
import { KLineType } from './KLineType';
import { KLocalAxis } from '../geom/KLocalAxis';
import { KViewPort } from './KViewPort';
import { IRichGraphics } from './IRichGraphics';
import { K2DPathFigureLine } from '../geom/K2DPathFigureLine';
import { K2DPathFigurePoint } from '../geom/K2DPathFigurePoint';
/**
 * @author matsuzaki
 **/
export declare abstract class AbstractRichGraphics implements IRichGraphics {
    /**
     * 1ドットの長さ**/
    protected mDotPerLen: number;
    /**
     * ビューポート**/
    protected mViewPort: KViewPort;
    /**
     * デバイスサイズ**/
    protected mDimension: KDimension;
    /**
     * 1rad
     **/
    protected static RAD: number;
    /****/
    constructor();
    /**
     * ビューポートの設定
     * @param vp
    **/
    setViewPort(vp: KViewPort): void;
    /**
     * ビューポートの取得
     * @return
    **/
    getViewPort(): KViewPort;
    setSize(w: number, h: number): void;
    getSize(): KDimension;
    /**
     * @return the dotPerLen**/
    getDotPerLen(): number;
    /**
     * ビューの設定
     * @param x1
     * @param y1
     * @param x2
     * @param y2
    **/
    setView(x1: number, y1: number, x2: number, y2: number, d?: KDimension): void;
    /**
     * 画面中心の移動
     * @param cx
     * @param cy
    **/
    setViewCenter(cx: number, cy: number): void;
    /**
     * 描画範囲を返します。
     * @return
    **/
    getDrawArea(): KArea;
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevX(x: number): number;
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevY(y: number): number;
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevXd(x: number): number;
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevYd(y: number): number;
    /**
     * 画面座標から実座標へ（ｘ）
     * @param x	デバイス座標値
     * @return		実座標値
    **/
    devToRealX(x: number): number;
    /**
     * 画面座標から実座標へ（ｙ）
     * @param y	デバイス座標値
     * @return		実座標値
    **/
    devToRealY(y: number): number;
    /**
     * 1ドットの長さを更新**/
    updateViewScale(d: KDimension): void;
    drawPolygon(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    drawFillPolygon(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    drawPolyLine(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    isInCanvas(x: number, y: number): boolean;
    protected getx(x: number, y: number, la: KLocalAxis): number;
    protected gety(x: number, y: number, la: KLocalAxis): number;
    pathAdd(col: Array<K2DPathFigureLine>, la: KLocalAxis): void;
    /**
     * 円弧パスの追加
     * anglが負の場合は時計回り。
     * @param xc
     * @param yc
     * @param ra
     * @param ss
     * @param ee
     * @param la
     * @author kawae
     * @since 2006/01/18
    **/
    pathArc(cx: number, cy: number, r: number, h: number, startAngle: number, arcAngle: number, la: KLocalAxis): void;
    abstract drawCircle(p0: number, p1: number, p2: number, p3: number, p4: number, p5: KLineType): void;
    abstract drawEllipse(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: KLineType): void;
    abstract drawFillCircle(p0: number, p1: number, p2: number, p3: number, p4: number, p5: KLineType): void;
    abstract drawFillEllipse(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: KLineType): void;
    abstract drawFillRect(p0: number, p1: number, p2: number, p3: number, p4: KLineType): void;
    abstract drawFillRoundRect(p0: number, p1: number, p2: number, p3: number, p4: number, p5: KLineType): void;
    abstract drawImageId(img: KImage, id: string, x1: number, y1: number, x2: number, y2: number): void;
    abstract drawImagePrefixId(img: KImage, prefix: string, id: string, x1: number, y1: number, x2: number, y2: number): void;
    abstract drawImagePosition(img: KImage, x1: number, y1: number, x2: number, y2: number): void;
    abstract drawImageRect(img: KImage, cx: number, cy: number, width: number, height: number, angle: number): void;
    abstract drawLine(p0: number, p1: number, p2: number, p3: number, p4: KLineType): void;
    abstract drawMark(p0: number, p1: number, p2: number, p3: number): void;
    abstract drawPath(p0: KLineType): void;
    abstract drawRect(p0: number, p1: number, p2: number, p3: number, p4: KLineType): void;
    abstract drawRoundRect(p0: number, p1: number, p2: number, p3: number, p4: number, p5: KLineType): void;
    abstract drawText(p0: string, p1: number, p2: number, p3: string, p4: number, p5: number, p6: number): void;
    abstract fillPath(p0: KLineType): void;
    abstract getQuality(): boolean;
    abstract pathClear(): void;
    abstract pathClose(): void;
    abstract pathCurveTo(p0: number, p1: number, p2: number, p3: number, p4: number, p5: number, p6: KLocalAxis): void;
    abstract pathInit(p0: number): void;
    abstract pathLineTo(p0: number, p1: number, p2: KLocalAxis): void;
    abstract pathMoveTo(p0: number, p1: number, p2: KLocalAxis): void;
    abstract pathQuadTo(p0: number, p1: number, p2: number, p3: number, p4: KLocalAxis): void;
    abstract releaseClipArea(): void;
    abstract setClipArea(p0: number, p1: number, p2: number, p3: number): void;
    abstract setColor(p0: KFill): void;
    abstract setQuality(p0: boolean): void;
}
