var ObjectNode_1 = require('../util/tree/ObjectNode');
var Base64Encoder_1 = require('./Base64Encoder');
var Base64Decoder_1 = require('./Base64Decoder');
var ObjectFolder_1 = require('../util/tree/ObjectFolder');
//import { XMLWriter } from '../util/xml/XMLWriter'
//import { XMLManager } from '../util/xml/XMLManager'
//import { AbstFile } from './AbstFile'
//module jp.kitec.lib.io
/**
 * @author kawae**/
var FileSystem = (function () {
    ///**
    // * コンストラクタ**/
    //public constructor() {
    //    this.mRootFolder = new ObjectFolder("ROOT");
    //}
    /**
     * コンストラクタ
     * @param basedir	基本ディレクトリ
    **/
    function FileSystem(basedir) {
        if (basedir === void 0) { basedir = null; }
        this.mRootFolder = new ObjectFolder_1.ObjectFolder("ROOT");
        if (basedir) {
            this.mBaseDir = basedir;
            if (this.mBaseDir != null && this.mBaseDir.indexOf('\\') >= 0)
                this.mBaseDir = this.mBaseDir.replace(/\\/, FileSystem.SEPARATOR);
        }
    }
    /**
     * rootフォルダの取得
     * @return
    **/
    FileSystem.prototype.getRootFolder = function () {
        return this.mRootFolder;
    };
    /**
     * ターゲットノードの取得
     * @param s		パス
     * @return
    **/
    FileSystem.prototype.getTargetNode = function (s) {
        var st = s.split(FileSystem.SEPARATOR_CANDIDATE_REGEXP);
        var parent = this.mRootFolder;
        if (st.length > 0) {
            var countToken = st.length;
            for (var i = 0; i < countToken - 1; i++) {
                var folder = st[i];
                parent = FileSystem.getFolder(parent, folder);
            }
            var o = parent.getNode(st[countToken - 1]);
            if (o != null && !(o instanceof ObjectFolder_1.ObjectFolder)) {
                var on = (o);
                return on;
            }
        }
        return null;
    };
    /**
     * ノードの追加
     * @param s
     * @param af
    **/
    FileSystem.prototype.addFile = function (s, af) {
        var st = s.split(FileSystem.SEPARATOR_CANDIDATE_REGEXP);
        var parent = this.mRootFolder;
        if (st.length > 0) {
            var countToken = st.length;
            for (var i = 0; i < countToken - 1; i++) {
                var folder = st[i];
                parent = FileSystem.getFolder(parent, folder);
            }
            parent.addChild(new ObjectNode_1.ObjectNode(st[countToken - 1], af != null ? Base64Encoder_1.Base64Encoder.encode(af) : null));
        }
    };
    /**
     * フォルダの追加
     * @param s		フォルダパス
    **/
    FileSystem.prototype.addPath = function (s) {
        var st = s.split(FileSystem.SEPARATOR_CANDIDATE_REGEXP);
        var parent = this.mRootFolder;
        if (st.length > 0) {
            var countToken = st.length;
            for (var i = 0; i < countToken; i++) {
                var folder = st[i];
                parent = FileSystem.getFolder(parent, folder);
            }
        }
    };
    /**
     * ファイルシステムの開放
     * @param on
    **/
    FileSystem.prototype.releaseFileSystem = function () {
        this.release(this.mRootFolder);
        this.mRootFolder = null;
    };
    /**
     * ファイルシステムのクローズ
     * 全キャッシュの開放
     * @param on
    **/
    FileSystem.prototype.release = function (on) {
        if (on instanceof ObjectFolder_1.ObjectFolder) {
            var of = (on);
            for (var i = 0; i < of.getChildren().length; i++) {
                var cn = of.getChildren()[i];
                this.release(cn);
            }
            of.getChildren().length = 0;
        }
        else {
            on.setParent(null);
            on.setObject(null);
        }
    };
    /**
     * フォルダ要素の取得
     * 存在しなければ作成する。
     * @param parent	親フォルダ
     * @param tag		検索サブフォルダ名
     * @param key		検索要素名
     * @param value	検索要素値
     * @return
    **/
    FileSystem.getFolder = function (parent, tag) {
        var v = parent.getNamedElement(tag);
        for (var i = 0; i < v.length; i++) {
            var on = v[i];
            if (on instanceof ObjectFolder_1.ObjectFolder)
                return (on);
        }
        var newf = new ObjectFolder_1.ObjectFolder(tag);
        parent.addChild(newf, true);
        return newf;
    };
    //TODO: implement for js
    ///**
    // * 転送用データの取得
    // * @return
    //**/
    //getTransData(): number[] {
    //    try {
    //        let af = new AbstFile();
    //        let ps = new PrintStream(af.openOutputStream(""));
    //        XMLWriter.write(this.mRootFolder, "", ps);
    //        ps.close();
    //        return af.getData();
    //    }
    //    catch (e: Exception) {
    //        FileSystem.log.error("XML作成エラー", e);
    //    }
    //    return null;
    //}
    ///**
    // * 転送用データの設定
    // * @param data
    //**/
    //setTransData(data: number[]): void {
    //    let man = new XMLManager();
    //    let af = new AbstFile();
    //    af.setData(data);
    //    if (man.load(af)) {
    //        this.mRootFolder = man.getTree();
    //        FileSystem.decodeBinaryData(this.mRootFolder);
    //    }
    //}
    /**
     * 名前を持つフォルダのデータの取得
     * @param parent
     * @param s
     * @return
    **/
    FileSystem.prototype.searchNode = function (parent, s) {
        if (parent == null) {
            parent = this.mRootFolder;
        }
        for (var i = 0; i < parent.getChildren().length; i++) {
            var o = parent.getChildren()[i];
            if (o instanceof ObjectFolder_1.ObjectFolder) {
                var res = this.searchNode((o), s);
                if (res != null)
                    return res;
            }
            else {
                var on = (o);
                if (on.getName() != null && on.getName().toLowerCase() === s.toLowerCase() && on.getObject() instanceof Array) {
                    return (on.getObject());
                }
            }
        }
        return null;
    };
    /**
     * 保持ノードすべてデコードする
     * @param on
    **/
    FileSystem.decodeBinaryData = function (on) {
        if (on instanceof ObjectFolder_1.ObjectFolder) {
            var of = (on);
            if (of.getChildren() != null) {
                for (var i = 0; i < of.getChildren().length; i++) {
                    var on2 = (of.getChildren()[i]);
                    FileSystem.decodeBinaryData(on2);
                }
            }
        }
        else {
            //var data: Object = on.getObject();
            if (on.isStringObject()) {
                on.setObject(Base64Decoder_1.Base64Decoder.decode(on.getString()));
            }
        }
    };
    /**
     * 保持ノードすべてデコードする
     * @param on
    **/
    FileSystem.encodeBinaryData = function (on) {
        if (on instanceof ObjectFolder_1.ObjectFolder) {
            var of = (on);
            if (of.getChildren() != null) {
                for (var i = 0; i < of.getChildren().length; i++) {
                    var on2 = of.getChildren()[i];
                    FileSystem.encodeBinaryData(on2);
                }
            }
        }
        else {
            var data = on.getObject();
            if (data instanceof Array) {
                on.setObject(Base64Encoder_1.Base64Encoder.encode(data));
            }
        }
    };
    //static log: Log = LogFactory.getLog(FileSystem);
    /**
     * ディレクトリセパレータ **/
    FileSystem.SEPARATOR = '/';
    FileSystem.SEPARATOR_CANDIDATE_REGEXP = "[\\\\/]+";
    return FileSystem;
})();
exports.FileSystem = FileSystem;
//# sourceMappingURL=FileSystem.js.map