//module jp.kitec.lib.io
/**
 * @author kamimura
 **/
var Base64Encoder;
(function (Base64Encoder) {
    var traslation_array = [
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
        'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
        'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',
        'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
        'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x',
        'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
        '8', '9', '+', '/'];
    function encode(source, user_len) {
        if (user_len === void 0) { user_len = 72; }
        var len;
        if (user_len > 76 || user_len % 4 != 0) {
            len = 76;
        }
        else {
            len = user_len;
        }
        var out = "";
        var character_counter = 0;
        var length = (source.length / 3) | 0;
        for (var i = 0; i < length; i++) {
            out += encode3bytes(source, i * 3, 3);
            character_counter++;
            if (character_counter == len / 4) {
                out += "\n";
                character_counter = 0;
            }
        }
        if (source.length % 3 == 2) {
            out += encode3bytes(source, source.length - 2, 2);
            out += "\n";
        }
        else if (source.length % 3 == 1) {
            out += encode3bytes(source, source.length - 1, 1);
            out += "\n";
        }
        else {
            if (character_counter != 0) {
                out += "\n";
            }
        }
        return out;
    }
    Base64Encoder.encode = encode;
    /**
     * 3バイトを4文字に変換
     * @param source
     * @param position
     * @param num
     * @returnString
    **/
    function encode3bytes(source, position, num) {
        var result = "";
        var z = 0;
        if (num == 1) {
            var byte1 = source[position];
            result += traslation_array[byte1 >>> 2 & 0x3f];
            result += traslation_array[(byte1 << 4 & 0x30) + (z >>> 4 & 0xf)];
            result += "==";
        }
        else if (num == 2) {
            var byte1 = source[position];
            var byte2 = source[position + 1];
            result += traslation_array[byte1 >>> 2 & 0x3f];
            result += traslation_array[(byte1 << 4 & 0x30) + (byte2 >>> 4 & 0xf)];
            result += traslation_array[(byte2 << 2 & 0x3c) + (z >>> 6 & 3)];
            result += "=";
        }
        else {
            var byte1 = source[position];
            var byte2 = source[position + 1];
            var byte3 = source[position + 2];
            result += traslation_array[byte1 >>> 2 & 0x3f];
            result += traslation_array[(byte1 << 4 & 0x30) + (byte2 >>> 4 & 0xf)];
            result += traslation_array[(byte2 << 2 & 0x3c) + (byte3 >>> 6 & 3)];
            result += traslation_array[byte3 & 0x3f];
        }
        return result;
    }
})(Base64Encoder = exports.Base64Encoder || (exports.Base64Encoder = {}));
//# sourceMappingURL=Base64Encoder.js.map