//import { AbstFile } from './AbstFile'
//module jp.kitec.lib.io
/**
 * Base64でエンコードされたテキストを読み込み、デコードしバイト列を出力する**/
var Base64Decoder;
(function (Base64Decoder) {
    //constructor() {
    //}
    /**
     * Base64エンコードされたテキストをバイナリに変換する。
     * テキストには改行コード等含んでも可
     * @param source Base64エンコードのテキスト
     * @return byte[]
    **/
    function decode(source) {
        var ptr = 0;
        function get4bytes(t) {
            var status = false;
            var data;
            for (var i = 0; i < 4; i++) {
                do {
                    if (ptr >= source.length)
                        return status;
                    data = source.charCodeAt(ptr++) & 0xff;
                } while (convert_array[data] == -1 && !(data == 61));
                t[i] = data;
                status = true;
            }
            return status;
        }
        var base64 = new Array(4);
        var out = [];
        while (get4bytes(base64)) {
            decode4bytes(base64, out);
        }
        return out;
    }
    Base64Decoder.decode = decode;
    //static decode(pis : InputStream) : number[] /*IOException*/ {
    //    var bos : ByteArrayOutputStream = new ByteArrayOutputStream();
    //    var base64 : number[] = new Array(4);
    //    while (Base64Decoder.get4bytes(pis, base64)) {
    //        bos.write(Base64Decoder.decode4bytes(base64));
    //    }
    //    return bos.toByteArray();
    //}
    function decode4bytes(source, decoded) {
        var buffer = new Array(4);
        buffer[0] = convert_array[source[0]];
        buffer[1] = convert_array[source[1]];
        buffer[2] = convert_array[source[2]];
        buffer[3] = convert_array[source[3]];
        if (buffer[2] == -1 && buffer[3] == -1) {
            decoded.push((buffer[0] << 2 & 0xfc | buffer[1] >>> 4 & 3) & 0xff);
        }
        else if (buffer[2] != -1 && buffer[3] == -1) {
            decoded.push((buffer[0] << 2 & 0xfc | buffer[1] >>> 4 & 3) & 0xff);
            decoded.push((buffer[1] << 4 & 0xf0 | buffer[2] >>> 2 & 0xf) & 0xff);
        }
        else {
            decoded.push((buffer[0] << 2 & 0xfc | buffer[1] >>> 4 & 3) & 0xff);
            decoded.push((buffer[1] << 4 & 0xf0 | buffer[2] >>> 2 & 0xf) & 0xff);
            decoded.push((buffer[2] << 6 & 0xc0 | buffer[3] & 0x3f) & 0xff);
        }
    }
    var translation_array = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'];
    var convert_array;
    {
        convert_array = new Array(256);
        for (var i = 0; i < 255; i++) {
            convert_array[i] = -1;
        }
        for (var j = 0; j < translation_array.length; j++) {
            convert_array[translation_array[j].charCodeAt(0)] = j;
        }
    }
})(Base64Decoder = exports.Base64Decoder || (exports.Base64Decoder = {}));
//# sourceMappingURL=Base64Decoder.js.map