//import { error } from '../../common'
//import { InputStream } from '../../../../java/io/InputStream'
//import { AbstFile } from '../../io/AbstFile'
var XMLParser_1 = require('./XMLParser');
//module jp.kitec.lib.util.xml
/**
 * XML 管理クラス。
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
var XMLManager = (function () {
    function XMLManager() {
    }
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML データ入力オブジェクト
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    //load(in_$ : AbstFile) : boolean {
    //    var xml : XMLParser = new XMLParser();
    //    this.mObjFolder = xml.load(in_$);
    //    return (this.mObjFolder != null) ? true : false;
    //}
    //load(in_$ : AbstFile, encode : string) : boolean {
    //    var xml : XMLParser = new XMLParser();
    //    this.mObjFolder = xml.load(in_$, encode);
    //    return (this.mObjFolder != null) ? true : false;
    //}
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML データ入力ストリーム
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    XMLManager.prototype.load = function (data) {
        var xml = new XMLParser_1.XMLParser();
        this.mObjFolder = xml.load(data);
        return (this.mObjFolder != null) ? true : false;
    };
    XMLManager.prototype.loadIntArray = function (data) {
        var xml = new XMLParser_1.XMLParser();
        this.mObjFolder = xml.loadIntArray(data);
        return (this.mObjFolder != null) ? true : false;
    };
    /**
     * XML を表す木構造のデータを返す。
     * @return		木構造データ
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    XMLManager.prototype.getTree = function () {
        return this.mObjFolder;
    };
    XMLManager.ENC_64_CHARS = ["<", ">", "\""];
    XMLManager.BASE64_TAG_BRGIN = "__BEGIN_BASE64ENCODED__";
    XMLManager.BASE64_TAG_END = "__END_BASE64ENCODED__";
    return XMLManager;
})();
exports.XMLManager = XMLManager;
//# sourceMappingURL=XMLManager.js.map