/**
 * 幾何計算クラス**/
export declare module MathUtil {
    var EPS: number;
    const D2R: number;
    /**
     * 小数点s桁以降を切り捨てる。
     * @param f
     * @param s
     * @return
    **/
    function kirisute(f: number, s: number): number;
    /**
     * 外積(のZ値)を求める**/
    function crossProduct(p0x: number, p0y: number, p1x: number, p1y: number, p2x: number, p2y: number): number;
    /**
     * ２つの角度の差(360度内で）
     * getAnglGapRad()とは挙動が違うので注意**/
    function getAnglGapDeg(a: number, b: number): number;
    /**
     * ２つの角度の差(2PI度内で）
     * getAnglGapDeg()とは挙動が違うので注意**/
    function getAnglGapRad(a: number, b: number): number;
    /**
     * 360度内で開始角と終了角の間にあるか(ラジアン)**/
    function isInnerAngl2PI(s: number, e: number, a: number): boolean;
    /**
     * 360度内で開始角と終了角の間にあるか(度)**/
    function isInnerAngl360(s: number, e: number, a: number): boolean;
    /**
     * 円弧の始点・終点と点の距離を調べる
     * @param x
     * @param y
     * @param r
     * @param s
     * @param e
     * @param x
     * @param y
     * @param dir
     * @return
    **/
    function getLengthToArcStartEnd(cx: number, cy: number, r: number, s: number, x: number, y: number): number;
    function rachet(angl: number, rat: number): number;
    /**
     * 2直線の角度の取得（時計回り方向）
     * @param ax1
     * @param ay1
     * @param ax2
     * @param ay2
     * @param bx1
     * @param by1
     * @param bx2
     * @param by2
     * @return
    **/
    function getAngle2Lines(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number): number;
    /**
     * ２Dでの角度の計算
     * @param x1 点１のX座標
     * @param y1 点１のY座標
     * @param x2 点２のX座標
     * @param y2 点２のY座標
     * @return 角度（ラジアン）
    **/
    function getAngle2D(x1: number, y1: number, x2: number, y2: number): number;
    /**
     * 直線をローカル座標X軸とした場合の点のXの値を取得
     * @param x		検証する点X
     * @param y		検証する点Y
     * @param x1	原点側X
     * @param y1	原点側Y
     * @param x2	X軸側X
     * @param y2	X軸側Y
     * @return		ローカル座標系でのX座標
    **/
    function getX(x: number, y: number, x1: number, y1: number, x2: number, y2: number): number;
    /**
     * 線分p1-p2が線分p3-p4に含まれるか**/
    function inIncludeLine(p1x: number, p1y: number, p2x: number, p2y: number, p3x: number, p3y: number, p4x: number, p4y: number): boolean;
    /**
     * 直線をローカル座標X軸とした場合の点のYの値を取得
     * @param x
     * @param y
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     * @return
    **/
    function getY(x: number, y: number, x1: number, y1: number, x2: number, y2: number): number;
    /**
     * 象限を調べる。
     * @param px 検査する点のX座標
     * @param py 検査する点のY座標
     * @param x1 点１のX座標
     * @param y1 点１のY座標
     * @param x2 点２のX座標
     * @param y2 点２のY座標
    **/
    function getQuadrant(px: number, py: number, x1: number, y1: number, x2: number, y2: number): number;
    /**
     * 角度（ラジアン）を２＊PIの範疇に変更する
     * @param d
     * @return
    **/
    function getAngl2PI(d: number): number;
    /**
     * 角度（度）360度をの範疇に変更する
     * @param d
     * @return
    **/
    function getAngl360(d: number): number;
    /**
     * ２Dでの点の回転
     * @param xc 回転中心のX座標
     * @param yc 回転中心のX座標
     * @param rot 回転角度
     * @param xsrc 対象の点のX座標
     * @param ysrc 対象の点のY座標
     * @param res 結果座標
    **/
    function rotation2D(xc: number, yc: number, rot: number, xsrc: number, ysrc: number, res: number[]): void;
    /**
     * 2次元の2点の間の距離を調べる
     * @param x1 点１のX座標
     * @param y1 点１のY座標
     * @param x2 点２のX座標
     * @param y2 点２のY座標
    **/
    function getLength2D(x1: number, y1: number, x2: number, y2: number): number;
    /**
     * 2点が同じ位置にあるか検査
     * @param p1x 点1のX座標
     * @param p1y 点1のY座標
     * @param p2x 点2のX座標
     * @param p2y 点2のY座標
    **/
    function isSame2D(p1x: number, p1y: number, p2x: number, p2y: number): boolean;
    /**
     * 2直線が同じか調べる
     * @param pa1x 点１
    **/
    function isSameLine(pa1x: number, pa1y: number, pa2x: number, pa2y: number, pb1x: number, pb1y: number, pb2x: number, pb2y: number): boolean;
    /**
     * aはbに含まれるか**/
    function isIncludeLine(pa1x: number, pa1y: number, pa2x: number, pa2y: number, pb1x: number, pb1y: number, pb2x: number, pb2y: number): boolean;
    /**
     * 2線分が平行に関係を持つか
     * (平行かつ重なるか)**/
    function isRelatePara2Line(pa1x: number, pa1y: number, pa2x: number, pa2y: number, pb1x: number, pb1y: number, pb2x: number, pb2y: number): boolean;
    function isVerticalLimitLineToPoint2D(px: number, py: number, p1x: number, p1y: number, p2x: number, p2y: number, tmp: number[]): boolean;
    /**
     * 点から直線(無限)に垂直に降ろした交点を調べる
     * @param px	検査する点のX座標
     * @param py	検査する点のY座標
     * @param p1x	線の点１のX座標
     * @param p1y	線の点１のY座標
     * @param p2x	線の点２のX座標
     * @param p2y	線の点２のY座標
    **/
    function isCrossPointVertLimitlessLineToPoint2D(px: number, py: number, p1x: number, p1y: number, p2x: number, p2y: number, res: number[]): boolean;
    /**
     * 点と線分の距離を調べる
     * @param px 検査する点のX座標
     * @param py 検査する点のY座標
     * @param p1x 線分の点1のx座標
     * @param p1y 線分の点1のY座標
     * @param p2x 線分の点2のx座標
     * @param p2y 線分の点2のY座標
    **/
    function getLengthLimitLineToPoint2D(px: number, py: number, p1x: number, p1y: number, p2x: number, p2y: number): number;
    /**
     * 点と直線(無限)の距離を調べる
     * @param px	検査する点のX座標
     * @param py	検査する点のY座標
     * @param p1x	線分の点1のx座標
     * @param p1y	線分の点1のY座標
     * @param p2x	線分の点2のx座標
     * @param p2y	線分の点2のY座標
     * @return	点と線分の距離。計算できなければ-1を返す。
    **/
    function getLengthLimitlessLineToPoint2D(px: number, py: number, p1x: number, p1y: number, p2x: number, p2y: number): number;
    /**
     * 点と直線(無限)の位置を調べる
     * @param px	検査する点のX座標
     * @param py	検査する点のY座標
     * @param p1x	線分の点1のx座標
     * @param p1y	線分の点1のY座標
     * @param p2x	線分の点2のx座標
     * @param p2y	線分の点2のY座標
     * @return	上にあればtrue.下ならfalse。
    **/
    function isPointPickUporDown(px: number, py: number, p1x: number, p1y: number, p2x: number, p2y: number): boolean;
    /**
     * 点１から点２の方向にofsx,
     * そこから垂直にofsy（左が正）の位置を算出
     * @param x1		点１のX座標
     * @param y1		点１のY座標
     * @param x2		点２のX座標
     * @param y2		点２のY座標
     * @param ofsx	xオフセット(線方向)
     * @param ofsy	yオフセット(法線方向)
     * @param res		結果座標
    **/
    function getOffsetPoint2D(x1: number, y1: number, x2: number, y2: number, ofsx: number, ofsy: number, res: number[]): void;
    function getOffsetLength2D(x1: number, y1: number, x2: number, y2: number, ofsx: number, ofsy: number, res: number[]): void;
    /**
     * 3点を通る円の半径と中心点の取得**/
    function get3PointCircle(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, res: number[]): number;
    /**
     * 3点を通る円の半径と中心点の取得**/
    function get2LineArc(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, res: number[]): number;
    /**
     * 2線分が交点を持つか調べる
     * @param ap1x	線１の点１のX座標
     * @param ap1y	線１の点１のY座標
     * @param bp1x	線２の点１のX座標
     * @param bp1y	線２の点１のY座標
     * @param res		結果座標
    **/
    function isCrossSegment(ap1x: number, ap1y: number, ap2x: number, ap2y: number, bp1x: number, bp1y: number, bp2x: number, bp2y: number, res: number[]): boolean;
    /**
     * 2直線(無限)が交点を持つか調べる
     * @param ap1x	線１の点１のX座標
     * @param ap1y	線１の点１のY座標
     * @param ap2x	線１の点２のX座標
     * @param ap2y	線１の点２のY座標
     * @param bp1x	線２の点１のX座標
     * @param bp1y	線２の点１のY座標
     * @param bp2x	線２の点２のX座標
     * @param bp2y	線２の点２のY座標
     * @param res		結果座標
    **/
    function isCrossInfinity(ap1x: number, ap1y: number, ap2x: number, ap2y: number, bp1x: number, bp1y: number, bp2x: number, bp2y: number, res: number[]): boolean;
    function isCrossInfinityEq(a1: number, b1: number, c1: number, a2: number, b2: number, c2: number, res: number[]): boolean;
    function isCrossInfinityPointAndAngle(x1: number, y1: number, ang1: number, xa: number, ya: number, anga: number, tmpf: number[]): boolean;
    function isCrossXandLimitLine(x: number, bp1x: number, bp1y: number, bp2x: number, bp2y: number, res: number[]): boolean;
    function isCrossYandLimitLine(y: number, bp1x: number, bp1y: number, bp2x: number, bp2y: number, res: number[]): boolean;
    /**
     * 2直線が同一線上に存在するか
     * @param ap1x	線１の点１のX座標
     * @param ap1y	線１の点１のY座標
     * @param ap2x	線１の点２のX座標
     * @param ap2y	線１の点２のY座標
     * @param bp1x	線２の点１のX座標
     * @param bp1y	線２の点１のY座標
     * @param bp2x	線２の点２のX座標
     * @param bp2y	線２の点２のY座標
    **/
    function isOnLine(ap1x: number, ap1y: number, ap2x: number, ap2y: number, bp1x: number, bp1y: number, bp2x: number, bp2y: number): boolean;
    /**
     * 点が線分上にあるか調べる
     * @param px	検査する点のX座標
     * @param py	検査する点のY座標
     * @param p1x	線分の点１のX座標
     * @param p1y	線分の点１のY座標
     * @param p2x	線分の点２のX座標
     * @param p2y	線分の点２のY座標
    **/
    function isOnLimitLinePoint2D(px: number, py: number, p1x: number, p1y: number, p2x: number, p2y: number): boolean;
    /**
     * 2直線が平行か調べる
     * @param ap1x	線１の点１のX座標
     * @param ap1y	線１の点１のY座標
     * @param ap2x	線１の点２のX座標
     * @param ap2y	線１の点２のY座標
     * @param bp1x	線２の点１のX座標
     * @param bp1y	線２の点１のY座標
     * @param bp2x	線２の点２のX座標
     * @param bp2y	線２の点２のY座標
    **/
    function isParallel2D(ap1x: number, ap1y: number, ap2x: number, ap2y: number, bp1x: number, bp1y: number, bp2x: number, bp2y: number): boolean;
    /**
     * 二直線から垂直にオフセットした交点を計算**/
    function get2LineOffsetCross(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, ofs1: number, ofs2: number, tmp: number[]): boolean;
    /**
     * 楕円と楕円中心から点へ繋がる線の交点を算出
     * 線は無限。
     * @param x		楕円中心と繋がる点のX座標
     * @param y		楕円中心と繋がる点のY座標
     * @param cpx	楕円中心X
     * @param cpy	楕円中心Y
     * @param rh	楕円幅半径
     * @param rv	楕円高半径
     * @param tmp	交点
    **/
    function getCrossPointEllipse(x: number, y: number, cpx: number, cpy: number, rh: number, rv: number, tmp: number[]): void;
    /**
     * 楕円度の取得
     * @param rh
     * @param rv
     * @param angl
     * @return
    **/
    function getEllipseAngl(rh: number, rv: number, angl: number): number;
    /**
     * 直線の方程式の切片Aを算出
     * @param p1x	線分の点1のx座標
     * @param p1y	線分の点1のY座標
     * @param p2x	線分の点2のx座標
     * @param p2y	線分の点2のY座標
     * @return
    **/
    function getLineEquation2Da(p1x: number, p1y: number, p2x: number, p2y: number): number;
    /**
     * 直線の方程式の切片Bを算出
     * @param p1x	線分の点1のx座標
     * @param p1y	線分の点1のY座標
     * @param p2x	線分の点2のx座標
     * @param p2y	線分の点2のY座標
     * @return
    **/
    function getLineEquation2Db(p1x: number, p1y: number, p2x: number, p2y: number): number;
    /**
     * 直線の方程式の切片Cを算出
     * @param p1x	線分の点1のx座標
     * @param p1y	線分の点1のY座標
     * @param p2x	線分の点2のx座標
     * @param p2y	線分の点2のY座標
     * @return
    **/
    function getLineEquation2Dc(p1x: number, p1y: number, p2x: number, p2y: number): number;
    /**
     * 丸める**/
    function norm(f: number): number;
    /**
     * メソッド名　 : 配列の平均化？<BR>
     * 処理内容　　 : <BR>
     * 事前条件 　　: <BR>
     * 事後条件　　 : <BR>
     * @param vt 配列
     * @return        標準偏差？
     * @exception なし
     * @since         2003/09/10
     * @author        fujita
     * @version       2003/09/10
    **/
    function normalizeVector(vt: number[]): number;
    /**
     * メソッド名　 : ３次元空間における２点間の距離の取得<BR>
     * 処理内容　　 : ３次元空間において、a 点と b 点間の距離を算出し返す。<BR>
     * 事前条件 　　: <BR>
     * 事後条件　　 : <BR>
     * @param a ３次元空間での点
     * @param b ３次元空間での点
     * @return        ２点間の距離
     * @exception なし
     * @since         2003/09/10
     * @author        fujita
     * @version       2003/09/10
    **/
    function getDistanceOn3D(a: number[], b: number[]): number;
    /**
     * メソッド名　 : <BR>
     * 処理内容　　 : <BR>
     * 事前条件 　　: <BR>
     * 事後条件　　 : <BR>
     * @param なし
     * @return        なし
     * @exception なし
     * @since         2003/09/10
     * @author        fujita
     * @version       2003/09/10
    **/
    function calcOuterProduct(a: number[], b: number[], c: number[]): void;
}
