/**
 * リスト中のアイテム。<BR>
 * 自身の前後のアイテムを保持する。<BR>
 * @since 　2002/12/20
 * @author　Kawae
 * @version 2002/12/20
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
export declare class Item<T> {
    /**
     * このアイテムの次のアイテム **/
    nextItem: Item<T>;
    /**
     * このアイテムの前のアイテム **/
    prevItem: Item<T>;
    /**
     * このアイテムと関連（所有）するデータ **/
    _object: T;
    /**
     * 指定されたデータを持ち、前後のアイテムのない（=null）の
     * 新たなアイテムを作成する。
     * @param i	データ
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    constructor(i: T);
    /**
     * このアイテムが保持するデータ返す。
     * @return	データ
     * @see #setObject(Object)
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getObject(): T;
    /**
     * 指定されたデータを、このアイテムのデータとして設定する。
     * @param o	データ
     * @see #getObject()
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    setObject(o: T): void;
}
