//import { HashUtil } from '../util/HashUtil'
var ObjectFolder_1 = require('../util/tree/ObjectFolder');
var MathUtil_1 = require('../util/MathUtil');
//module jp.kitec.kwt
/**
 * 領域クラス
 * @author kawae
**/
var KArea = (function () {
    function KArea(x1, y1, x2, y2) {
        if (x1 === void 0) { x1 = 0; }
        if (y1 === void 0) { y1 = 0; }
        if (x2 === void 0) { x2 = 0; }
        if (y2 === void 0) { y2 = 0; }
        this.setArea(x1, y1, x2, y2);
    }
    KArea.prototype.width = function () {
        return this.maxX - this.minX;
    };
    KArea.prototype.height = function () {
        return this.maxY - this.minY;
    };
    KArea.prototype.maximize = function () {
        this.minX = this.minY = Number.POSITIVE_INFINITY;
        this.maxX = this.maxY = Number.NEGATIVE_INFINITY;
    };
    KArea.prototype.setArea = function (v, y1, x2, y2) {
        if (v instanceof KArea) {
            var a = v;
            this.minX = a.minX;
            this.minY = a.minY;
            this.maxX = a.maxX;
            this.maxY = a.maxY;
        }
        else {
            var x1 = typeof v !== "number" ? 0 : v;
            x2 = x2 === undefined ? 0 : x2;
            y1 = y1 === undefined ? 0 : y1;
            y2 = y2 === undefined ? 0 : y2;
            this.maximize();
            this.updateMinMax(x1, y1);
            this.updateMinMax(x2, y2);
        }
    };
    KArea.prototype.updateMinMax = function (v, y) {
        if (v instanceof KArea) {
            var a = v;
            this.updateMinMax(a.minX, a.minY);
            this.updateMinMax(a.maxX, a.maxY);
        }
        else {
            var x = v;
            this.minX = this.minX > x ? x : this.minX;
            this.minY = this.minY > y ? y : this.minY;
            this.maxX = this.maxX < x ? x : this.maxX;
            this.maxY = this.maxY < y ? y : this.maxY;
        }
    };
    KArea.prototype.updateMinMaxX = function (x) {
        this.minX = this.minX > x ? x : this.minX;
        this.maxX = this.maxX < x ? x : this.maxX;
    };
    KArea.prototype.updateMinMaxY = function (y) {
        this.minY = this.minY > y ? y : this.minY;
        this.maxY = this.maxY < y ? y : this.maxY;
    };
    KArea.prototype.isInner = function (x, y) {
        return this.maxX >= x && x >= this.minX && this.maxY >= y && y >= this.minY;
    };
    KArea.prototype.distanceTo = function (x, y) {
        if (x < this.minX) {
            if (y < this.minY) {
                return MathUtil_1.MathUtil.getLength2D(this.minX, this.minY, x, y);
            }
            else if (y < this.maxY) {
                return this.minX - x;
            }
            else {
                return MathUtil_1.MathUtil.getLength2D(this.minX, this.maxY, x, y);
            }
        }
        else if (x < this.maxX) {
            if (y < this.minY) {
                return this.minY - y;
            }
            else if (y < this.maxY) {
                return 0;
            }
            else {
                return y - this.maxY;
            }
        }
        else {
            if (y < this.minY) {
                return MathUtil_1.MathUtil.getLength2D(this.maxX, this.minY, x, y);
            }
            else if (y < this.maxY) {
                return x - this.maxX;
            }
            else {
                return MathUtil_1.MathUtil.getLength2D(this.maxX, this.maxY, x, y);
            }
        }
    };
    //hashCode(): number {
    //    let prime = 31;
    //    let result = 1;
    //    result = prime * result + HashUtil.hashCode(this.maxX);
    //    result = prime * result + HashUtil.hashCode(this.maxY);
    //    result = prime * result + HashUtil.hashCode(this.minX);
    //    result = prime * result + HashUtil.hashCode(this.minY);
    //    return result;
    //}
    KArea.prototype.equals = function (other) {
        if (this === other)
            return true;
        if (other == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        //var other: KArea = ((obj) as KArea);
        if (this.minX !== other.minX)
            return false;
        if (this.minY !== other.minY)
            return false;
        if (this.maxX !== other.maxX)
            return false;
        if (this.maxY !== other.maxY)
            return false;
        return true;
    };
    KArea.prototype.save = function (savenode) {
        savenode.setName(KArea.GEOMNAME);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "minX", this.minX);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "minY", this.minY);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "maxX", this.maxX);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "maxY", this.maxY);
    };
    KArea.readData = function (datanode, a) {
        var on;
        if ((on = datanode.getNode("minX")) != null)
            a.minX = on.getDouble(0);
        if ((on = datanode.getNode("minY")) != null)
            a.minY = on.getDouble(0);
        if ((on = datanode.getNode("maxX")) != null)
            a.maxX = on.getDouble(0);
        if ((on = datanode.getNode("maxY")) != null)
            a.maxY = on.getDouble(0);
    };
    KArea.GEOMNAME = "AREA";
    return KArea;
})();
exports.KArea = KArea;
//# sourceMappingURL=KArea.js.map