import { ObjectNode } from '../util/tree/ObjectNode';
import { ObjectFolder } from '../util/tree/ObjectFolder';
/**
 * @author kawae**/
export declare class FileSystem {
    /**
     * ディレクトリセパレータ **/
    static SEPARATOR: string;
    static SEPARATOR_CANDIDATE_REGEXP: string;
    /**
     * トップフォルダ **/
    mRootFolder: ObjectFolder;
    /**
     * 基本フォルダの場所。ファイルはすべてこのフォルダの相対パスとして管理される **/
    mBaseDir: string;
    /**
     * コンストラクタ
     * @param basedir	基本ディレクトリ
    **/
    constructor(basedir?: string);
    /**
     * rootフォルダの取得
     * @return
    **/
    getRootFolder(): ObjectFolder;
    /**
     * ターゲットノードの取得
     * @param s		パス
     * @return
    **/
    getTargetNode(s: string): ObjectNode;
    /**
     * ノードの追加
     * @param s
     * @param af
    **/
    addFile(s: string, af: number[]): void;
    /**
     * フォルダの追加
     * @param s		フォルダパス
    **/
    addPath(s: string): void;
    /**
     * ファイルシステムの開放
     * @param on
    **/
    releaseFileSystem(): void;
    /**
     * ファイルシステムのクローズ
     * 全キャッシュの開放
     * @param on
    **/
    release(on: ObjectNode): void;
    /**
     * フォルダ要素の取得
     * 存在しなければ作成する。
     * @param parent	親フォルダ
     * @param tag		検索サブフォルダ名
     * @param key		検索要素名
     * @param value	検索要素値
     * @return
    **/
    static getFolder(parent: ObjectFolder, tag: string): ObjectFolder;
    /**
     * 名前を持つフォルダのデータの取得
     * @param parent
     * @param s
     * @return
    **/
    searchNode(parent: ObjectFolder, s: string): number[];
    /**
     * 保持ノードすべてデコードする
     * @param on
    **/
    static decodeBinaryData(on: ObjectNode): void;
    /**
     * 保持ノードすべてデコードする
     * @param on
    **/
    static encodeBinaryData(on: ObjectNode): void;
}
