var Base64Decoder_1 = require('./Base64Decoder');
var Base64Encoder_1 = require('./Base64Encoder');
//module jp.kitec.lib.io
function getBytes(s) {
    var bytes = [];
    for (var i = 0; i < s.length; i++) {
        bytes.push(s.charCodeAt(i));
    }
    return bytes;
}
QUnit.test("testEncodeByteArray()", function () {
    QUnit.equal("VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wcyBvdmVyIHRoZSBsYXp5IGRvZy4=", Base64Encoder_1.Base64Encoder.encode(getBytes("The quick brown fox jumps over the lazy dog.")).trim());
    try {
        Base64Encoder_1.Base64Encoder.encode(null);
        QUnit.ok(false);
    }
    catch (e) {
        QUnit.ok(true);
    }
});
QUnit.test("testEncodeByteArrayInt()", function () {
    var base64Str;
    var lines;
    var shortInput = "The quick brown fox jumps over the lazy dog.";
    var longInput = "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog.";
    var fold;
    var separator = /\n/;
    fold = 72;
    base64Str = Base64Encoder_1.Base64Encoder.encode(getBytes(longInput));
    lines = base64Str.split(separator).filter(function (s) { return s.length > 0; });
    QUnit.equal(4, lines.length);
    checkFold(lines, fold);
    QUnit.deepEqual(getBytes(longInput), Base64Decoder_1.Base64Decoder.decode(base64Str));
    fold = 4;
    base64Str = Base64Encoder_1.Base64Encoder.encode(getBytes(shortInput), fold);
    lines = base64Str.split(separator).filter(function (s) { return s.length > 0; });
    QUnit.equal(15, lines.length);
    checkFold(lines, fold);
    QUnit.deepEqual(getBytes(shortInput), Base64Decoder_1.Base64Decoder.decode(base64Str));
    fold = 90;
    base64Str = Base64Encoder_1.Base64Encoder.encode(getBytes(shortInput), fold);
    lines = base64Str.split(separator).filter(function (s) { return s.length > 0; });
    QUnit.equal(1, lines.length);
    checkFold(lines, 76);
    QUnit.deepEqual(getBytes(shortInput), Base64Decoder_1.Base64Decoder.decode(base64Str));
    fold = 72;
    base64Str = Base64Encoder_1.Base64Encoder.encode(getBytes(longInput));
    lines = base64Str.split(separator).filter(function (s) { return s.length > 0; });
    QUnit.equal(4, lines.length);
    checkFold(lines, fold);
    QUnit.deepEqual(getBytes(longInput), Base64Decoder_1.Base64Decoder.decode(base64Str));
});
function checkFold(lines, fold) {
    for (var i = 0; i < lines.length; i++) {
        if (i < lines.length - 1) {
            QUnit.equal(lines[i].length, fold);
        }
        else {
            QUnit.ok(lines[i].length <= fold);
        }
    }
}
//# sourceMappingURL=Base64EncoderTest.js.map