import { K2DPathFigure } from './K2DPathFigure';
/**
 * ２次元点要素のインターフェース
 * 2DのPoint系は全てこれをインプリすること。
 * @author kawae
 * @since 2006/01/13
**/
export interface K2DPathFigurePoint extends K2DPathFigure {
    /**
     * Ｘ座標値を取得する。
     * @return	Ｘ座標値
     * @author kawae
     * @since 2006/01/13
    **/
    getX(): number;
    /**
     * Ｙ座標値を取得する。
     * @return	Ｙ座標値
     * @author kawae
     * @since 2006/01/13
    **/
    getY(): number;
    /**
     * Ｘ座標値をセットする。
     * @param x	Ｘ座標値
     * @author kawae
     * @since 2006/01/13
    **/
    setX(x: number): void;
    /**
     * Ｙ座標値をセットする。
     * @param y	Ｙ座標値
     * @author kawae
     * @since 2006/01/13
    **/
    setY(y: number): void;
    /**
     * ＸＹ座標をセットする
     * @param x
     * @param y
     * @author kawae
     * @since 2006/01/16
    **/
    setXY(x: number, y: number): void;
}
