/**
 * String関係のユーティリティ
 * @author kawae
 * @since 2005/03/16
**/
export declare class UtilString {
    /**
     * タブをスペースに変更
     * @param s
     * @return
     * @author kawae
     * @since 2005/03/16
    **/
    static tab2space(s: string): string;
    /**
     * メッセージダイジェストの取得
     * @param s
     * @return
     * @author kawae
     * @since 2005/09/05
    **/
    /**
     * 変換用の全角数字
     **/
    static ZENKAKU_TABLE: Map<string, string>;
    /**
     * 指定された半角数字の文字列を、全角数字の文字列へ変換する。
     * 数字以外の場合、全角へは変換されず、もとの文字が設定される。
     * @param str	半角数字の文字列
     * @return 全角数字の文字列
     * @since   2003/02/13
     * @author  Kawae
     * @version 2003/02/13
    **/
    static getZenkakuNumberExPeriod(str: string): string;
    /**
     * 半角か確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    static isHankaku(c: number): boolean;
    /**
     * 半角カナか確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    static isHankakuKana(c: number): boolean;
    /**
     * 全角カナか確認
     * @author kawae
     * @since 2005/01/06
    **/
    static isZenkakuKana(c: number): boolean;
    /**
     * 全角ひらがなか確認
     * @author kawae
     * @since 2005/01/06
    **/
    static isFullHiraKana(c: number): boolean;
    /**
     * 半角数字か確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    static isHankakuSuuji(c: number): boolean;
    /**
     * 全角数字か確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    static isZenkakuSuuji(c: number): boolean;
    /**
     * 特定のエンコーディングで利用出来る文字か確認
     * @param s
     * @return
     * @author kawae
     * @since 2006/01/12
    **/
    /**
     * 特定のエンコーディングで利用出来る文字か確認
     * @param s
     * @return
     * @author kawae
     * @since 2006/01/12
    **/
    /**
     * 文字列が異なるか確認
     * @param s1
     * @param s2
     * @return
     * @author kawae
     * @since 2004/09/26
    **/
    static isDiff(s1: string, s2: string, compareUpperLower?: boolean): boolean;
    /**
     * 文字配列が異なるか確認
     * @param s1
     * @param s2
     * @return
     * @author kawae
     * @since 2004/09/26
    **/
    static isDiffArray(s1: string[], s2: string[], compareUpperLower?: boolean): boolean;
    static bin2dec(s: string): number;
}
