var KViewPort_1 = require('./KViewPort');
//module jp.kitec.kwt
function equal(expect, actual, eps) {
    QUnit.ok(Math.abs(expect - actual) <= eps);
}
QUnit.test("testKViewPort()", function () {
    var vp = new KViewPort_1.KViewPort();
    QUnit.equal("", vp.getViewPortName());
});
QUnit.test("testKViewPortString()", function () {
    var vp = new KViewPort_1.KViewPort("vp");
    QUnit.equal("vp", vp.getViewPortName());
});
QUnit.test("testSetViewPortName()", function () {
    var vp = new KViewPort_1.KViewPort("vp");
    vp.setViewPortName("abc");
    QUnit.equal("abc", vp.getViewPortName());
    vp.setViewPortName(null);
    QUnit.equal(null, vp.getViewPortName());
});
QUnit.test("testGetViewPortName()", function () {
    var vp = new KViewPort_1.KViewPort("vp");
    vp.setViewPortName("abc");
    QUnit.equal("abc", vp.getViewPortName());
    vp.setViewPortName(null);
    QUnit.equal(null, vp.getViewPortName());
});
QUnit.test("testGetCopy()", function () {
    var vp = new KViewPort_1.KViewPort("vp");
    vp.resetViewPort(0, 0, 400, 200, 10);
    var vp2 = vp.getCopy();
    QUnit.equal(vp.getViewPortName(), vp2.getViewPortName());
    equal(vp.getCx(), vp2.getCx(), 0);
    equal(vp.getCy(), vp2.getCy(), 0);
    equal(vp.getX1(), vp2.getX1(), 0);
    equal(vp.getY1(), vp2.getY1(), 0);
    equal(vp.getX2(), vp2.getX2(), 0);
    equal(vp.getY2(), vp2.getY2(), 0);
});
QUnit.test("testSetViewPort()", function () {
    var vp = new KViewPort_1.KViewPort("vp");
    vp.resetViewPort(0, 0, 400, 200, 10);
    var vp2 = new KViewPort_1.KViewPort("vp2");
    vp2.setViewPort(vp);
    QUnit.equal("vp2", vp2.getViewPortName());
    equal(vp.getCx(), vp2.getCx(), 0);
    equal(vp.getCy(), vp2.getCy(), 0);
    equal(vp.getX1(), vp2.getX1(), 0);
    equal(vp.getY1(), vp2.getY1(), 0);
    equal(vp.getX2(), vp2.getX2(), 0);
    equal(vp.getY2(), vp2.getY2(), 0);
});
QUnit.test("testResetViewPort()", function () {
    var vp = new KViewPort_1.KViewPort("vp");
    vp.resetViewPort(0, 0, 400, 200, 10);
    equal(-10, vp.getX1(), 0.1);
    equal(-10, vp.getY1(), 0.1);
    equal(410, vp.getX2(), 0.1);
    equal(210, vp.getY2(), 0.1);
    equal(200, vp.getCx(), 0.1);
    equal(100, vp.getCy(), 0.1);
    vp.resetViewPort(0, 0, 400, 200, 0);
    equal(0, vp.getX1(), 0.1);
    equal(0, vp.getY1(), 0.1);
    equal(400, vp.getX2(), 0.1);
    equal(200, vp.getY2(), 0.1);
    equal(200, vp.getCx(), 0.1);
    equal(100, vp.getCy(), 0.1);
});
//# sourceMappingURL=KViewPortTest.js.map