var KArea_1 = require('./KArea');
var KRotatedArea_1 = require('./KRotatedArea');
var ObjectFolder_1 = require('../util/tree/ObjectFolder');
var vecmathjs_1 = require('vecmathjs');
//module jp.kitec.kwt
function equal(expect, actual, eps) {
    QUnit.ok(Math.abs(expect - actual) <= eps);
}
QUnit.test("testUpdateMinMax()", function () {
    var r = new KRotatedArea_1.KRotatedArea();
    var area = new KArea_1.KArea();
    r.setCenter(new vecmathjs_1.Point2d(100, -200));
    r.setSize(new vecmathjs_1.Vector2d(10, 0));
    r.setRotation(0);
    area.maximize();
    r.updateMinMax(area);
    equal(95, area.minX, 0.01);
    equal(105, area.maxX, 0.01);
    equal(-200, area.minY, 0.01);
    equal(-200, area.maxY, 0.01);
    r.setCenter(new vecmathjs_1.Point2d(100, -200));
    r.setSize(new vecmathjs_1.Vector2d(10, 0));
    r.setRotation(Math.PI / 2);
    area.maximize();
    r.updateMinMax(area);
    equal(100, area.minX, 0.01);
    equal(100, area.maxX, 0.01);
    equal(-205, area.minY, 0.01);
    equal(-195, area.maxY, 0.01);
    r.setCenter(new vecmathjs_1.Point2d(100, -200));
    r.setSize(new vecmathjs_1.Vector2d(0, 10));
    r.setRotation(0);
    area.maximize();
    r.updateMinMax(area);
    equal(100, area.minX, 0.01);
    equal(100, area.maxX, 0.01);
    equal(-205, area.minY, 0.01);
    equal(-195, area.maxY, 0.01);
});
QUnit.test("testSaveLoad()", function () {
    var r = new KRotatedArea_1.KRotatedArea();
    r.setCenter(new vecmathjs_1.Point2d(100.3, -200));
    r.setSize(new vecmathjs_1.Vector2d(10, 0));
    r.setRotation(Math.PI);
    var of = new ObjectFolder_1.ObjectFolder("");
    r.save(of);
    var read = new KRotatedArea_1.KRotatedArea();
    KRotatedArea_1.KRotatedArea.readData(of, read);
    QUnit.ok(r.equals(read));
});
//# sourceMappingURL=KRotatedAreaTest.js.map