var ObjectFolder_1 = require('../util/tree/ObjectFolder');
var MathUtil_1 = require('../util/MathUtil');
var vecmathjs_1 = require('vecmathjs');
//module jp.kitec.kwt
var KRotatedArea = (function () {
    function KRotatedArea() {
        this.center = new vecmathjs_1.Point2d();
        this.size = new vecmathjs_1.Vector2d();
        this.rotation = 0;
    }
    KRotatedArea.prototype.set = function (a) {
        this.center.set_tuple(a.center);
        this.size.set_tuple(a.size);
        this.rotation = a.rotation;
    };
    KRotatedArea.prototype.getCenter = function () {
        return this.center;
    };
    KRotatedArea.prototype.setCenter = function (center) {
        this.center.set_tuple(center);
    };
    KRotatedArea.prototype.getSize = function () {
        return this.size;
    };
    KRotatedArea.prototype.setSize = function (size) {
        this.size.set_tuple(size);
    };
    KRotatedArea.prototype.getRotation = function () {
        return this.rotation;
    };
    KRotatedArea.prototype.setRotation = function (rotation) {
        this.rotation = rotation;
    };
    KRotatedArea.prototype.updateMinMax = function (area) {
        var sin = Math.sin(this.rotation);
        var cos = Math.cos(this.rotation);
        area.updateMinMax(this.center.x + this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin + this.size.y / 2 * cos);
        area.updateMinMax(this.center.x + this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin - this.size.y / 2 * cos);
        area.updateMinMax(this.center.x - this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin - this.size.y / 2 * cos);
        area.updateMinMax(this.center.x - this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin + this.size.y / 2 * cos);
    };
    KRotatedArea.prototype.getDirX = function () {
        return new vecmathjs_1.Vector2d(Math.cos(this.rotation), Math.sin(this.rotation));
    };
    KRotatedArea.prototype.getDirY = function () {
        return new vecmathjs_1.Vector2d(Math.cos(this.rotation + Math.PI / 2), Math.sin(this.rotation + Math.PI / 2));
    };
    KRotatedArea.prototype.distanceTo = function (x, y) {
        var cx = x - this.center.x;
        var cy = y - this.center.y;
        var p = new vecmathjs_1.Vector2d(cx, cy);
        var dx = this.getDirX();
        var dy = this.getDirY();
        var ax = dx.dot(p);
        var ay = dy.dot(p);
        var sx = this.size.x / 2;
        var sy = this.size.y / 2;
        if (ax >= -sx / 2 && ax <= sx && ay >= -sy && ay <= sy)
            return 0;
        if (ax < -sx) {
            if (ay <= -sy) {
                return MathUtil_1.MathUtil.getLength2D(-sx, -sy, ax, ay);
            }
            else if (ay >= sy) {
                return MathUtil_1.MathUtil.getLength2D(-sx, sy, ax, ay);
            }
            else {
                return -sx - ax;
            }
        }
        else if (ax > sx) {
            if (ay <= -sy) {
                return MathUtil_1.MathUtil.getLength2D(sx, -sy, ax, ay);
            }
            else if (ay >= sy) {
                return MathUtil_1.MathUtil.getLength2D(sx, sy, ax, ay);
            }
            else {
                return ax - sx;
            }
        }
        else {
            if (ay <= -sy) {
                return -sy - ay;
            }
            else if (ay >= sy) {
                return ay - sy;
            }
            else {
                return 0;
            }
        }
    };
    KRotatedArea.prototype.getPoints = function () {
        var sin = Math.sin(this.rotation);
        var cos = Math.cos(this.rotation);
        return [new vecmathjs_1.Point2d(this.center.x + this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin + this.size.y / 2 * cos), new vecmathjs_1.Point2d(this.center.x + this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin - this.size.y / 2 * cos), new vecmathjs_1.Point2d(this.center.x - this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin - this.size.y / 2 * cos), new vecmathjs_1.Point2d(this.center.x - this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin + this.size.y / 2 * cos)];
    };
    KRotatedArea.prototype.save = function (savenode) {
        savenode.setName(KRotatedArea.GEOMNAME);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "cx", this.center.x);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "cy", this.center.y);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "sx", this.size.x);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "sy", this.size.y);
        ObjectFolder_1.ObjectFolder.addNodeDouble(savenode, "rot", this.rotation);
    };
    KRotatedArea.readData = function (datanode, r) {
        var on;
        if ((on = datanode.getNode("cx")) != null)
            r.center.x = on.getDouble(0);
        if ((on = datanode.getNode("cy")) != null)
            r.center.y = on.getDouble(0);
        if ((on = datanode.getNode("sx")) != null)
            r.size.x = on.getDouble(0);
        if ((on = datanode.getNode("sy")) != null)
            r.size.y = on.getDouble(0);
        if ((on = datanode.getNode("rot")) != null)
            r.rotation = on.getDouble(0);
    };
    //hashCode() : number {
    //    var prime : number = 31;
    //    var result : number = 1;
    //    result = prime * result + ((this.center == null) ? 0 : this.center.hashCode());
    //    result = prime * result + Double.valueOf(this.rotation).hashCode();
    //    result = prime * result + ((this.size == null) ? 0 : this.size.hashCode());
    //    return result;
    //}
    KRotatedArea.prototype.equals = function (obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this.center == null) {
            if (other.center != null)
                return false;
        }
        else if (!this.center.equals(other.center))
            return false;
        if (this.rotation !== other.rotation)
            return false;
        if (this.size == null) {
            if (other.size != null)
                return false;
        }
        else if (!this.size.equals(other.size))
            return false;
        return true;
    };
    KRotatedArea.GEOMNAME = "ROTATEDAREA";
    return KRotatedArea;
})();
exports.KRotatedArea = KRotatedArea;
//# sourceMappingURL=KRotatedArea.js.map