var common_1 = require('../common');
//module jp.kitec.kwt
/**
 * 線種指定クラス
 * @author kawae
**/
var KLineType = (function () {
    /**
     * コンストラクタ
     * @param name
     * @param str
     * @param w
     * @param widType
    **/
    function KLineType(name, str, w, widType, cap, join, miterLimit) {
        if (name === void 0) { name = ""; }
        if (str === void 0) { str = null; }
        if (w === void 0) { w = 1; }
        if (widType === void 0) { widType = KLineType.TYPE_DRAWING; }
        if (cap === void 0) { cap = KLineType_Cap.BUTT; }
        if (join === void 0) { join = KLineType_Join.MITER; }
        if (miterLimit === void 0) { miterLimit = 1; }
        /**
         * 幅 **/
        this.mWidth = 0;
        if (cap == null || join == null)
            throw new common_1.error.lang.NullPointerException();
        this.mName = name;
        this.mStroke = str;
        this.mWidth = w;
        this.mWidthType = widType;
        this.mCap = cap;
        this.mJoin = join;
        this.mMiterLimit = miterLimit;
    }
    /**
     * 名称を返す
     * @return
    **/
    KLineType.prototype.name = function () {
        return this.mName;
    };
    /**
     * ストロークを返す
     * @return
    **/
    KLineType.prototype.stroke = function () {
        return this.mStroke;
    };
    /**
     * 幅を返す
     * @return
    **/
    KLineType.prototype.width = function () {
        return this.mWidth;
    };
    /**
     * 幅指定オプションを返す
     * @return
    **/
    KLineType.prototype.widthType = function () {
        return this.mWidthType;
    };
    /**
     * 両端部オプションを返す
     * @return
    **/
    KLineType.prototype.cap = function () {
        return this.mCap;
    };
    /**
     * 接合部オプションを返す
     * @return
    **/
    KLineType.prototype.join = function () {
        return this.mJoin;
    };
    /**
     * 接合トリミングの制限を返す
     * @return
    **/
    KLineType.prototype.miterLimit = function () {
        return this.mMiterLimit;
    };
    /**
     * 現在のKLineTypeに新しいストロークを適用した複製を返す
     * @param stroke
     * @return
    **/
    KLineType.prototype.deriveStroke = function (stroke) {
        return new KLineType(this.mName, stroke, this.mWidth, this.mWidthType, this.mCap, this.mJoin, this.mMiterLimit);
    };
    /**
     * 現在のKLineTypeに新しい幅を適用した複製を返す
     * @param width
     * @return
    **/
    KLineType.prototype.deriveWidth = function (width) {
        return new KLineType(this.mName, this.mStroke, width, this.mWidthType, this.mCap, this.mJoin, this.mMiterLimit);
    };
    /**
     * 現在のKLineTypeに新しい幅指定オプションを適用した複製を返す
     * @param widthType
     * @return
    **/
    KLineType.prototype.deriveWidthType = function (widthType) {
        return new KLineType(this.mName, this.mStroke, this.mWidth, widthType, this.mCap, this.mJoin, this.mMiterLimit);
    };
    /**
     * 現在のKLineTypeに新しい両端部オプションを適用した複製を返す
     * @param cap
     * @return
    **/
    KLineType.prototype.deriveCap = function (cap) {
        return new KLineType(this.mName, this.mStroke, this.mWidth, this.mWidthType, cap, this.mJoin, this.mMiterLimit);
    };
    /**
     * 現在のKLineTypeに新しい接合部オプションを適用した複製を返す
     * @param join
     * @return
    **/
    KLineType.prototype.deriveJoin = function (join) {
        return new KLineType(this.mName, this.mStroke, this.mWidth, this.mWidthType, this.mCap, join, this.mMiterLimit);
    };
    /**
     * 現在のKLineTypeに新しい接合トリミング制限を適用した複製を返す
     * @param miterLimit
     * @return
    **/
    KLineType.prototype.deriveMiterLimit = function (miterLimit) {
        return new KLineType(this.mName, this.mStroke, this.mWidth, this.mWidthType, this.mCap, this.mJoin, miterLimit);
    };
    KLineType.prototype.save = function (savenode) {
        savenode.setName(KLineType.GEOMNAME);
        if (this.mName != null)
            savenode.addNode("name", this.mName);
        if (this.mStroke != null) {
            var sb = "";
            for (var i = 0; i < this.mStroke.length; i++) {
                sb += this.mStroke[i];
                if (i != this.mStroke.length - 1)
                    sb += ",";
            }
            var s = sb;
            if (s.length > 0)
                savenode.addNode("stroke", s);
        }
        savenode.addNode("width", this.mWidth);
        savenode.addNode("cap", KLineType_Cap[this.mCap]);
        savenode.addNode("join", KLineType_Join[this.mJoin]);
        savenode.addNode("miterlimit", this.mMiterLimit);
    };
    KLineType.readData = function (of, l) {
        var l = l || new KLineType(null, null, 0);
        var on;
        if ((on = of.getNode("name")) != null)
            l.mName = on.getString();
        if ((on = of.getNode("stroke")) != null) {
            var str = on.getString();
            var st = str.split(",");
            l.mStroke = new Array(st.length);
            for (var i = 0; i < l.mStroke.length; i++)
                l.mStroke[i] = parseFloat(st[i]);
        }
        if ((on = of.getNode("width")) != null)
            l.mWidth = on.getFloat();
        if ((on = of.getNode("cap")) != null)
            l.mCap = KLineType_Cap[on.getString()];
        if ((on = of.getNode("join")) != null)
            l.mJoin = KLineType_Join[on.getString()];
        if ((on = of.getNode("miterlimit")) != null)
            l.mMiterLimit = on.getFloat();
        return l;
    };
    KLineType.GEOMNAME = "LINETYPE";
    /**
     * 実座標系での幅指定 **/
    KLineType.TYPE_DRAWING = 0;
    /**
     * デバイス座標系での幅指定 **/
    KLineType.TYPE_DEVICE = 1;
    return KLineType;
})();
exports.KLineType = KLineType;
(function (KLineType_Cap) {
    //enum constant declarations
    KLineType_Cap[KLineType_Cap["BUTT"] = 0] = "BUTT";
    KLineType_Cap[KLineType_Cap["ROUND"] = 1] = "ROUND";
    KLineType_Cap[KLineType_Cap["SQUARE"] = 2] = "SQUARE";
})(exports.KLineType_Cap || (exports.KLineType_Cap = {}));
var KLineType_Cap = exports.KLineType_Cap;
(function (KLineType_Join) {
    //enum constant declarations
    KLineType_Join[KLineType_Join["BEVEL"] = 0] = "BEVEL";
    KLineType_Join[KLineType_Join["MITER"] = 1] = "MITER";
    KLineType_Join[KLineType_Join["ROUND"] = 2] = "ROUND";
})(exports.KLineType_Join || (exports.KLineType_Join = {}));
var KLineType_Join = exports.KLineType_Join;
//# sourceMappingURL=KLineType.js.map