import { ObjectFolder } from '../util/tree/ObjectFolder';
/**
 * 線種指定クラス
 * @author kawae
**/
export declare class KLineType {
    static GEOMNAME: string;
    /**
     * 実座標系での幅指定 **/
    static TYPE_DRAWING: number;
    /**
     * デバイス座標系での幅指定 **/
    static TYPE_DEVICE: number;
    /**
     * 名称 **/
    private mName;
    /**
     * ストローク **/
    private mStroke;
    /**
     * 幅 **/
    private mWidth;
    /**
     * 幅指定オプション **/
    private mWidthType;
    /**
     * 両端部オプション **/
    private mCap;
    /**
     * 接合部オプション **/
    private mJoin;
    /**
     * 接合トリミングの制限 **/
    private mMiterLimit;
    /**
     * コンストラクタ
     * @param name
     * @param str
     * @param w
     * @param widType
    **/
    constructor(name?: string, str?: number[], w?: number, widType?: number, cap?: KLineType_Cap, join?: KLineType_Join, miterLimit?: number);
    /**
     * 名称を返す
     * @return
    **/
    name(): string;
    /**
     * ストロークを返す
     * @return
    **/
    stroke(): number[];
    /**
     * 幅を返す
     * @return
    **/
    width(): number;
    /**
     * 幅指定オプションを返す
     * @return
    **/
    widthType(): number;
    /**
     * 両端部オプションを返す
     * @return
    **/
    cap(): KLineType_Cap;
    /**
     * 接合部オプションを返す
     * @return
    **/
    join(): KLineType_Join;
    /**
     * 接合トリミングの制限を返す
     * @return
    **/
    miterLimit(): number;
    /**
     * 現在のKLineTypeに新しいストロークを適用した複製を返す
     * @param stroke
     * @return
    **/
    deriveStroke(stroke: number[]): KLineType;
    /**
     * 現在のKLineTypeに新しい幅を適用した複製を返す
     * @param width
     * @return
    **/
    deriveWidth(width: number): KLineType;
    /**
     * 現在のKLineTypeに新しい幅指定オプションを適用した複製を返す
     * @param widthType
     * @return
    **/
    deriveWidthType(widthType: number): KLineType;
    /**
     * 現在のKLineTypeに新しい両端部オプションを適用した複製を返す
     * @param cap
     * @return
    **/
    deriveCap(cap: KLineType_Cap): KLineType;
    /**
     * 現在のKLineTypeに新しい接合部オプションを適用した複製を返す
     * @param join
     * @return
    **/
    deriveJoin(join: KLineType_Join): KLineType;
    /**
     * 現在のKLineTypeに新しい接合トリミング制限を適用した複製を返す
     * @param miterLimit
     * @return
    **/
    deriveMiterLimit(miterLimit: number): KLineType;
    save(savenode: ObjectFolder): void;
    static readData(of: ObjectFolder, l?: KLineType): KLineType;
}
export declare enum KLineType_Cap {
    BUTT = 0,
    ROUND = 1,
    SQUARE = 2,
}
export declare enum KLineType_Join {
    BEVEL = 0,
    MITER = 1,
    ROUND = 2,
}
