var ObjectFolder_1 = require('../util/tree/ObjectFolder');
//module jp.kitec.kwt
var KDimension = (function () {
    function KDimension(widthOrDim, height) {
        if (widthOrDim instanceof KDimension) {
            var dim = widthOrDim;
            this.width = dim.width;
            this.height = dim.height;
            return;
        }
        if (typeof widthOrDim === "number") {
            var width = widthOrDim;
            this.width = width;
            this.height = height;
        }
    }
    KDimension.prototype.hashCode = function () {
        var prime = 31;
        var result = 1;
        result = prime * result + this.height;
        result = prime * result + this.width;
        return result;
    };
    KDimension.prototype.equals = function (obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this.height != other.height)
            return false;
        if (this.width != other.width)
            return false;
        return true;
    };
    KDimension.prototype.save = function (savenode) {
        savenode.setName(KDimension.GEOMNAME);
        ObjectFolder_1.ObjectFolder.addNodeInt(savenode, "w", this.width);
        ObjectFolder_1.ObjectFolder.addNodeInt(savenode, "h", this.height);
    };
    KDimension.readData = function (datanode, r) {
        var on;
        if ((on = datanode.getNode("w")) != null)
            r.width = on.getInt(0);
        if ((on = datanode.getNode("h")) != null)
            r.height = on.getInt(0);
    };
    KDimension.GEOMNAME = "DIMENSION";
    return KDimension;
})();
exports.KDimension = KDimension;
//# sourceMappingURL=KDimension.js.map