var KColor_1 = require('./KColor');
//module jp.kitec.kwt
QUnit.test("testKColorInt()", function () {
    var c1 = new KColor_1.KColor(0xffff0000);
    QUnit.equal(0xffff0000 | 0, c1.getRGB());
    var c2 = new KColor_1.KColor(0xff00ff);
    QUnit.equal(0xffff00ff | 0, c2.getRGB());
});
QUnit.test("testKColorIntBoolean()", function () {
    var c1 = new KColor_1.KColor(0xccff6699, true);
    QUnit.equal(0xccff6699 | 0, c1.getRGB() | 0);
    var c2 = new KColor_1.KColor(0xccff6699, false);
    QUnit.equal(0xffff6699 | 0, c2.getRGB() | 0);
});
QUnit.test("testKColorIntIntInt()", function () {
    var c1 = new KColor_1.KColor(0xcc, 0xff, 0x66);
    QUnit.equal(0xffccff66 | 0, c1.getRGB() | 0);
});
QUnit.test("testKColorIntIntIntInt()", function () {
    var c1 = new KColor_1.KColor(0xcc, 0xff, 0x66, 0x33);
    QUnit.equal(0x33ccff66 | 0, c1.getRGB() | 0);
});
QUnit.test("testGetElement()", function () {
    var c1 = new KColor_1.KColor(0xcc, 0xff, 0x66, 0x33);
    QUnit.equal(0xcc, c1.getRed());
    QUnit.equal(0xff, c1.getGreen());
    QUnit.equal(0x66, c1.getBlue());
    QUnit.equal(0x33, c1.getAlpha());
    QUnit.equal(0x33ccff66 | 0, c1.getRGB() | 0);
});
QUnit.test("testEncode()", function () {
    var c1 = new KColor_1.KColor(0xcc, 0xff, 0x66, 0x33);
    QUnit.equal("#33ccff66", c1.encode());
    QUnit.equal("#ff0000ff", KColor_1.KColor.BLUE.encode());
});
QUnit.test("testEqualsObject()", function () {
    var c1 = new KColor_1.KColor(0xcc, 0xff, 0x66, 0x33);
    var c2 = new KColor_1.KColor(0x33ccff66, true);
    QUnit.equal(true, c1.equals(c2));
    QUnit.equal(false, c1.equals(KColor_1.KColor.RED));
    //QUnit.equal(false, c1.equals("/"));
});
QUnit.test("testGetColorFromRGBString()", function () {
    QUnit.ok(new KColor_1.KColor(0, 255, 16).equals(KColor_1.KColor.getColorFromRGBString("0,255,16")));
});
QUnit.test("testGetColorRGBString()", function () {
    QUnit.equal("255,0,0", KColor_1.KColor.getColorRGBString(KColor_1.KColor.RED));
    QUnit.equal("0,255,255", KColor_1.KColor.getColorRGBString(KColor_1.KColor.CYAN));
    QUnit.equal("255,0,0", KColor_1.KColor.getColorRGBString(new KColor_1.KColor(255, 0, 0, 128)));
});
QUnit.test("testCompare()", function () {
    QUnit.equal(true, KColor_1.KColor.equals(new KColor_1.KColor(0, 1, 2, 3), new KColor_1.KColor(0, 1, 2, 3)));
    QUnit.equal(false, KColor_1.KColor.isDiff(new KColor_1.KColor(0, 1, 2, 3), new KColor_1.KColor(0, 1, 2, 3)));
    QUnit.equal(false, KColor_1.KColor.equals(new KColor_1.KColor(0, 1, 2, 3), new KColor_1.KColor(0, 1, 2, 4)));
    QUnit.equal(true, KColor_1.KColor.isDiff(new KColor_1.KColor(0, 1, 2, 3), new KColor_1.KColor(0, 1, 2, 4)));
    QUnit.equal(false, KColor_1.KColor.equals(KColor_1.KColor.RED, null));
    QUnit.equal(true, KColor_1.KColor.isDiff(KColor_1.KColor.RED, null));
    QUnit.equal(false, KColor_1.KColor.equals(null, KColor_1.KColor.RED));
    QUnit.equal(true, KColor_1.KColor.isDiff(null, KColor_1.KColor.RED));
});
QUnit.test("testDecode()", function () {
    QUnit.equal(0x33ccff66 | 0, KColor_1.KColor.decode("#33ccff66").getRGB() | 0);
    QUnit.ok(KColor_1.KColor.BLUE.equals(KColor_1.KColor.decode("#ff0000ff")));
    QUnit.equal(0x90ccff66 | 0, KColor_1.KColor.decode("0x90ccff66").getRGB() | 0);
    QUnit.equal(0x33ccff66 | 0, KColor_1.KColor.decode("0x33ccff66").getRGB() | 0);
    QUnit.equal(null, KColor_1.KColor.decode("abc"));
});
//# sourceMappingURL=KColorTest.js.map