//module jp.kitec.kwt
/**
 * @author kawae**/
var KColor = (function () {
    function KColor(rgbOrR, gOrHasAlpha, b, alpha) {
        if (gOrHasAlpha === undefined) {
            this._argb = rgbOrR | (0xff << 24);
            return;
        }
        if (typeof gOrHasAlpha === "boolean") {
            var hasAlpha = gOrHasAlpha;
            if (hasAlpha)
                this._argb = rgbOrR | 0;
            else
                this._argb = rgbOrR | (0xff << 24);
            return;
        }
        if (typeof gOrHasAlpha === "number") {
            var r = rgbOrR;
            var g = gOrHasAlpha;
            if (b === undefined)
                throw new Error();
            if (alpha === undefined)
                this._argb = b | (g << 8) | (r << 16) | (0xff << 24);
            else
                this._argb = b | (g << 8) | (r << 16) | (alpha << 24);
        }
        else {
            throw new Error();
        }
    }
    KColor.prototype.getRed = function () {
        return (this._argb >> 16) & 0xFF;
    };
    KColor.prototype.getRGB = function () {
        return this._argb;
    };
    KColor.prototype.getGreen = function () {
        return (this._argb >> 8) & 0xFF;
    };
    KColor.prototype.getBlue = function () {
        return this._argb & 0xFF;
    };
    KColor.prototype.getAlpha = function () {
        return (this._argb >> 24) & 0xFF;
    };
    KColor.prototype.darker = function () {
        return new KColor(((this.getRed() * KColor.SCALE_FACTOR)), ((this.getGreen() * KColor.SCALE_FACTOR)), ((this.getBlue() * KColor.SCALE_FACTOR)));
    };
    KColor.prototype.brighter = function () {
        var r = this.getRed();
        var b = this.getBlue();
        var g = this.getGreen();
        if (r == 0 && b == 0 && g == 0) {
            return new KColor(KColor.MIN_SCALABLE, KColor.MIN_SCALABLE, KColor.MIN_SCALABLE);
        }
        if (r < KColor.MIN_SCALABLE && r != 0) {
            r = KColor.MIN_SCALABLE;
        }
        else {
            r = ((r / KColor.SCALE_FACTOR));
            r = (r > 255) ? 255 : r;
        }
        if (b < KColor.MIN_SCALABLE && b != 0) {
            b = KColor.MIN_SCALABLE;
        }
        else {
            b = ((b / KColor.SCALE_FACTOR));
            b = (b > 255) ? 255 : b;
        }
        if (g < KColor.MIN_SCALABLE && g != 0) {
            g = KColor.MIN_SCALABLE;
        }
        else {
            g = ((g / KColor.SCALE_FACTOR));
            g = (g > 255) ? 255 : g;
        }
        return new KColor(r, g, b);
    };
    /**
     * ARGBを16進数で返す
     * @return
    **/
    KColor.prototype.encode = function () {
        var fill = "0";
        var sb = "";
        sb += "#";
        var s;
        s = this.getAlpha().toString(16);
        if (s.length == 1)
            sb += fill;
        sb += s;
        s = this.getRed().toString(16);
        if (s.length == 1)
            sb += fill;
        sb += s;
        s = this.getGreen().toString(16);
        if (s.length == 1)
            sb += fill;
        sb += s;
        s = this.getBlue().toString(16);
        if (s.length == 1)
            sb += fill;
        sb += s;
        return sb;
    };
    KColor.prototype.css = function () {
        var css = "rgba(";
        css += this.getRed();
        css += ",";
        css += this.getGreen();
        css += ",";
        css += this.getBlue();
        css += ",";
        css += this.getAlpha();
        css += ")";
        return css;
    };
    KColor.prototype.hashCode = function () {
        return this._argb;
    };
    KColor.prototype.equals = function (obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this._argb != other._argb)
            return false;
        return true;
    };
    /**
     * カンマ区切りのRGBからColorを作成
     * @param s
     * @return
     * @author kawae
     * @since 2004/10/12
    **/
    KColor.getColorFromRGBString = function (s) {
        var st = s.split(",");
        if (st.length != 3)
            return null;
        var r = parseInt(st[0]);
        var g = parseInt(st[1]);
        var b = parseInt(st[2]);
        if (isNaN(r) || isNaN(g) || isNaN(b))
            return null;
        return new KColor(r, g, b);
    };
    /**
     * カンマ区切りのRGB文字列の取得
     * @param c
     * @return
     * @author kawae
     * @since 2004/11/05
    **/
    KColor.getColorRGBString = function (c) {
        if (c != null)
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        return null;
    };
    /**
     * nullを許容する比較
     * @param c1
     * @param c2
     * @return
    **/
    KColor.isDiff = function (c1, c2) {
        if ((c1 == null) != (c2 == null))
            return true;
        if (c1 == null)
            return false;
        return c1.getRGB() != c2.getRGB();
    };
    KColor.equals = function (c1, c2) {
        return !KColor.isDiff(c1, c2);
    };
    /**
     * アルファ値を使ってKColorオブジェクトを作成する
     * @param val
     * @return
    **/
    KColor.decode = function (val) {
        var n;
        if (val.substr(0, 1) == "#")
            n = parseInt(val.substr(1), 16);
        else
            n = parseInt(val);
        if (isNaN(n))
            return null;
        return new KColor(n, true);
    };
    KColor.prototype.toString = function () {
        return "KColor[" + this.getAlpha() + ", " + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "]";
    };
    /**
     * 明るい黄色**/
    KColor.LIGHT_YELLOW = new KColor(255, 255, 192);
    /**
     * 濃い黄色**/
    KColor.DARK_YELLOW = new KColor(192, 192, 0);
    /**
     * 空色**/
    KColor.SKY_BLUE = new KColor(128, 128, 255);
    /**
     * 水色**/
    KColor.WATER = new KColor(147, 221, 221);
    /**
     * 濃い青**/
    KColor.DARK_BLUE = new KColor(0, 0, 128);
    /**
     * 明るい緑**/
    KColor.LIGHT_GREEN = new KColor(128, 255, 128);
    /**
     * 濃い緑**/
    KColor.DARK_GREEN = new KColor(0, 192, 0);
    /**
     * かなり明るい灰色**/
    KColor.MORELIGHT_GRAY = new KColor(220, 220, 220);
    /**
     * さらに明るい灰色**/
    KColor.SUPERLIGHT_GRAY = new KColor(240, 240, 240);
    /**
     * 明るい灰色**/
    KColor.LIGHT_GRAY2 = new KColor(212, 208, 200);
    KColor.WHITE = new KColor(255, 255, 255);
    KColor.LIGHT_GRAY = new KColor(192, 192, 192);
    KColor.GRAY = new KColor(128, 128, 128);
    KColor.DARK_GRAY = new KColor(64, 64, 64);
    KColor.BLACK = new KColor(0, 0, 0);
    KColor.RED = new KColor(255, 0, 0);
    KColor.PINK = new KColor(255, 175, 175);
    KColor.ORANGE = new KColor(255, 200, 0);
    KColor.YELLOW = new KColor(255, 255, 0);
    KColor.GREEN = new KColor(0, 255, 0);
    KColor.MAGENTA = new KColor(255, 0, 255);
    KColor.CYAN = new KColor(0, 255, 255);
    KColor.BLUE = new KColor(0, 0, 255);
    KColor.SCALE_FACTOR = 0.7;
    KColor.MIN_SCALABLE = 3;
    return KColor;
})();
exports.KColor = KColor;
//# sourceMappingURL=KColor.js.map