import { KArea } from './KArea';
import { KImage } from './KImage';
import { KFill } from './KFill';
import { KLineType } from './KLineType';
import { K2DPathFigurePoint } from '../geom/K2DPathFigurePoint';
import { KLocalAxis } from '../geom/KLocalAxis';
import { K2DPathFigureLine } from '../geom/K2DPathFigureLine';
/**
 * 描画インターフェース
 * @author kawae
 * @since 2004/09/29
**/
export interface IRichGraphics {
    /**
     * 高クオリティモードの設定
     * @param quality
     * @author kawae
     * @since 2005/01/30
    **/
    setQuality(quality: boolean): void;
    /**
     * クオリティモードの取得
     * @return
     * @author kawae
     * @since 2005/04/06
    **/
    getQuality(): boolean;
    setClipArea(x1: number, y1: number, x2: number, y2: number): void;
    releaseClipArea(): void;
    setColor(c: KFill): void;
    drawLine(x1: number, y1: number, x2: number, y2: number, lt: KLineType): void;
    drawCircle(xc1: number, yc1: number, ra: number, ss: number, ee: number, lt: KLineType): void;
    drawFillCircle(xc1: number, yc1: number, ra: number, ss: number, ee: number, lt: KLineType): void;
    drawEllipse(xc1: number, yc1: number, v: number, h: number, ss: number, ee: number, lt: KLineType): void;
    drawFillEllipse(xc1: number, yc1: number, v: number, h: number, ss: number, ee: number, lt: KLineType): void;
    drawRect(x1: number, y1: number, x2: number, y2: number, lt: KLineType): void;
    drawFillRect(x1: number, y1: number, x2: number, y2: number, lt: KLineType): void;
    drawRoundRect(x1: number, y1: number, x2: number, y2: number, round: number, lt: KLineType): void;
    drawFillRoundRect(x1: number, y1: number, x2: number, y2: number, round: number, lt: KLineType): void;
    drawPolygon(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    drawFillPolygon(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    drawPolyLine(poly: Array<K2DPathFigurePoint>, lt: KLineType): void;
    drawMark(x: number, y: number, r: number, type: number): void;
    /**
     * イメージの描画
     * イメージのIDを併用して描画する。
     * @param img	イメージオブジェクト
     * @param id	イメージファイルのID
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     * @author kawae
     * @since 2004/10/27
    **/
    drawImageId(img: KImage, id: string, x1: number, y1: number, x2: number, y2: number): void;
    drawImagePrefixId(img: KImage, prefix: string, id: string, x1: number, y1: number, x2: number, y2: number): void;
    drawImagePosition(img: KImage, x1: number, y1: number, x2: number, y2: number): void;
    drawImageRect(img: KImage, cx: number, cy: number, width: number, height: number, angle: number): void;
    drawText(s: string, x1: number, y1: number, fontname: string, fonttype: number, size: number, angl: number): void;
    /**
     * パスの初期化
     * @param i　塗潰しルール
     * @author kawae
     * @since 2006/01/18
    **/
    pathInit(i: number): void;
    /**
     * パスのクリア
     * @author kawae
     * @since 2006/01/18
    **/
    pathClear(): void;
    /**
     * パスの点移動
     * @param x
     * @param y
     * @param la
     * @author kawae
     * @since 2006/01/18
    **/
    pathMoveTo(x: number, y: number, la: KLocalAxis): void;
    /**
     * ラインパスの追加
     * @param x
     * @param y
     * @param la
     * @author kawae
     * @since 2006/01/18
    **/
    pathLineTo(x: number, y: number, la: KLocalAxis): void;
    /**
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     * @param la
     * @author kawae
     * @since 2006/01/18
    **/
    pathQuadTo(x1: number, y1: number, x2: number, y2: number, la: KLocalAxis): void;
    /**
     * 最終点からベジェ曲線パスの追加
     * @param x1
     * @param y1
     * @param x2
     * @param y2
     * @param x3
     * @param y3
     * @param la
     * @author kawae
     * @since 2006/01/18
    **/
    pathCurveTo(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, la: KLocalAxis): void;
    /**
     * パスを閉じる
     * @author kawae
     * @since 2006/01/18
    **/
    pathClose(): void;
    /**
     * パスの追加
     * @param col　パス要素のコレクション
     * @param la　ローカル座標
     * @author kawae
     * @since 2006/01/18
    **/
    pathAdd(col: Array<K2DPathFigureLine>, la: KLocalAxis): void;
    /**
     * ポリゴンの塗潰し
     * @param lt 線タイプ
     * @author kawae
     * @since 2006/01/18
    **/
    fillPath(lt: KLineType): void;
    /**
     * パスの描画
     * @param lt　線タイプ
     * @author kawae
     * @since 2006/01/18
    **/
    drawPath(lt: KLineType): void;
    /**
     * 円弧パスの追加
     * 常に反時計廻りとするが、anglが負の場合は時計回り。
     * @param xc　中心X座標
     * @param yc　中心Y座標
     * @param ra　半径
     * @param ss　開始角度（度）
     * @param ee　終了角度（度）
     * @param la　ローカル座標
     * @author kawae
     * @since 2006/01/18
    **/
    pathArc(xc: number, yc: number, rw: number, rh: number, startangl: number, angl: number, la: KLocalAxis): void;
    /**
     * 実座標での描画範囲を返す。サポートしていない場合はnullを返す。
     * @return
    **/
    getDrawArea(): KArea;
    /**
     * 単位長が何ドットになるかを返す。サポートしていない場合は0を返す。
     * @return the dot/len
    **/
    getDotPerLen(): number;
}
export declare module IRichGraphicsConst {
    /**
     * 　マーカー
     **/
    const MARK_CIR: number;
    const MARK_CIR_FILL: number;
    const MARK_REC: number;
    const MARK_REC_FILL: number;
    const MARK_CROS: number;
    /**
     * デバイスへの出力用のデフォルトの線種
     **/
    const LINE_1: KLineType;
    const LINE_2: KLineType;
    const LINE_3: KLineType;
    const LINE_DASH_1: KLineType;
    /**
     * 塗潰しルール（偶奇屈曲規則）
     **/
    const WIND_EVEN_ODD: number;
    /**
     * 塗潰しルール（非ゼロ屈曲規則）
     **/
    const WIND_NON_ZERO: number;
}
