import * as emutils from 'emutils';
import { XMLReader } from './XMLReader';
//module jp.kitec.lib.util.xml
/**
 * XML 解析クラス。<BR>
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
export class XMLParser {
    /**
     * 指定された in から XML データを読み込む。
     * @param in	XML データ入力オブジェクト
     * @return		XML データを正しく読み込めた場合、
     * そのデータを表す木構造オブジェクトtrue。
     * そうでない場合は、null
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    load(in_) {
        let of = this.read(in_);
        if (of == null) {
            return null;
        }
        return of.getChildren()[0];
    }
    loadIntArray(data, encode = "UTF-8") {
        if (encode && encode !== "UTF-8") {
            console.warn("encoding not supported " + encode);
        }
        let str = emutils.UTF8ArrayToString(data, 0);
        var of = this.read(str);
        if (of == null) {
            return null;
        }
        return of.getChildren()[0];
    }
    //load(in_$ : AbstFile) : ObjectFolder {
    //    var of : ObjectFolder = this.read(in_$, null);
    //    if (of == null) {
    //        return null;
    //    }
    //    return (((of.getChildren().get(0)) as ObjectNode) as ObjectFolder) ;
    //}
    //load(in_$ : AbstFile, encode : string) : ObjectFolder {
    //    var of : ObjectFolder = this.read(in_$, encode);
    //    if (of == null) {
    //        return null;
    //    }
    //    return (((of.getChildren().get(0)) as ObjectNode) as ObjectFolder) ;
    //}
    ///**
    // * 指定された in から XML データを読み込む。
    // * @param in	XML データ入力ストリーム
    // * @return		XML データを正しく読み込めた場合、
    // * そのデータを表す木構造オブジェクトtrue。
    // * そうでない場合は、null
    // * @since		2004/05/19
    // * @author		fujita
    // * @version	2004/05/19
    //**/
    //load(in_$ : InputStream) : ObjectFolder {
    //    var of : ObjectFolder = this.load(this.getInputFile(in_$));
    //    if (of == null) {
    //        return null;
    //    }
    //    return (((of.getChildren().get(0)) as ObjectNode) as ObjectFolder) ;
    //}
    //    /**
    //     * 指定された in をもとに、データ読み込みオブジェクトを作成する。
    //     * @param in	入力ストリーム
    //     * @return		データ読み込みオブジェクト
    //     * @since		2004/05/19
    //     * @author		fujita
    //     * @version	2004/05/19
    //    **/
    //    private getInputFile(in_$ : InputStream) : AbstFile {
    //    if (in_$ == null) return null;
    //    var af: AbstFile = new AbstFile();
    //    af.read(in_$, "");
    //    return af;
    //}
    /**
     * 指定された in から XML データを読み込む。
     * @param in	 XML データ入力オブジェクト
     * @return		 XML データを正しく読み込めた場合、そのデータを持つ
     * データオブジェクト。そうでない場合は、null
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    read(in_) {
        if (in_ == null) {
            return null;
        }
        var xml = new XMLReader(in_);
        //if (encode == null)
        return xml.read();
        //else
        //    return xml.read(encode);
    }
}
//# sourceMappingURL=XMLParser.js.map