import { ObjectFolder } from "./ObjectFolder";
import { ObjectNode } from "./ObjectNode";
//module jp.kitec.lib.util.tree
QUnit.test("testObjectNode()", function () {
    new ObjectNode("name", "value");
    new ObjectNode(null, null);
    QUnit.ok(true);
});
QUnit.test("testGetName()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal("name", on.getName());
    on = new ObjectNode(null, "value");
    QUnit.equal(null, on.getName());
});
QUnit.test("testSetName()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal("name", on.getName());
    on.setName("a");
    QUnit.equal("a", on.getName());
    on.setName("a>");
    QUnit.equal("a>", on.getName());
});
QUnit.test("testGetObject()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal("value", on.getObject());
});
QUnit.test("testSetObject()", function () {
    var on;
    on = new ObjectNode("name", "value");
    on.setObject("abc");
    QUnit.equal("abc", on.getObject());
    on.setObject(2);
    QUnit.equal(2, on.getObject());
});
QUnit.test("testGetParent()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal(null, on.getParent());
    var p = new ObjectFolder("parent");
    on.setParent(p);
    QUnit.equal(p, on.getParent());
});
QUnit.test("testSetParent()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal(null, on.getParent());
    var p = new ObjectFolder("p");
    on.setParent(p);
    QUnit.equal(p, on.getParent());
});
QUnit.test("testGetNodeString()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal("value", on.getString());
    on = new ObjectNode("name", "123");
    QUnit.equal("123", on.getString());
    on = new ObjectNode("name", null);
    QUnit.equal(null, on.getString());
    on = new ObjectNode("name", 1);
    QUnit.equal(null, on.getString(null));
});
QUnit.test("testGetNodeInt()", function () {
    var on;
    on = new ObjectNode("name", "value");
    try {
        on.getInt();
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__0) {
    }
    on = new ObjectNode("name", "123");
    QUnit.equal(123, on.getInt());
    on = new ObjectNode("name", "0x123");
    try {
        on.getInt();
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__1) {
    }
    on = new ObjectNode("name", "123.0");
    try {
        on.getInt();
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__2) {
    }
    //QUnit.equal(-1, on.getInt(-1));
    on = new ObjectNode("name", null);
    try {
        QUnit.equal(0, on.getInt());
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__3) {
    }
});
QUnit.test("testGetNodeFloat()", function () {
    var on;
    on = new ObjectNode("name", "value");
    try {
        on.getFloat();
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__0) {
    }
    on = new ObjectNode("name", "value");
    QUnit.equal(10, on.getFloat(10));
    on = new ObjectNode("name", "123");
    QUnit.equal(123, on.getFloat());
    on = new ObjectNode("name", "123");
    QUnit.equal(123, on.getFloat(20));
    on = new ObjectNode("name", "0x123");
    try {
        on.getFloat();
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__1) {
    }
    //QUnit.equal(0, on.getFloat());//XXX: cf. java
    on = new ObjectNode("name", "123.5");
    QUnit.ok(Math.abs(123.5 - on.getFloat()) <= 0.001);
    on = new ObjectNode("name", null);
    try {
        on.getFloat();
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__2) {
    }
    on = new ObjectNode("name", null);
    QUnit.ok(Math.abs(-1.0 - on.getFloat(-1)) <= 0.0);
    on = new ObjectNode("name", 1);
    try {
        on.getFloat();
        QUnit.ok(false, "例外がおこらなかった");
    }
    catch (e__3) {
    }
    QUnit.ok(Math.abs(-1.0 - on.getFloat(-1)) <= 0.0);
});
//QUnit.test("testGetNodeDouble()", function () {
//    var on: ObjectNode;
//    on = new ObjectNode("name", "value");
//    try {
//        on.getDouble();
//        QUnit.ok(false);
//    }
//    catch (e__0) {
//    }
//    QUnit.equal(432, on.getDouble(432));
//    on = new ObjectNode("name", "123");
//    QUnit.equal(123, on.getDouble());
//    on = new ObjectNode("name", "0x123");
//    try {
//        on.getDouble();
//        QUnit.ok(false);
//    }
//    catch (e__1) {
//    }
//    QUnit.equal(432, on.getDouble(432));
//    on = new ObjectNode("name", "123.5");
//    QUnit.equal(123.5, on.getDouble());
//    on = new ObjectNode("name", null);
//    try {
//        on.getDouble();
//        QUnit.ok(false);
//    }
//    catch (e__2) {
//    }
//    QUnit.equal(432, on.getDouble(432));
//});
QUnit.test("testGetNodeBool()", function () {
    var on;
    on = new ObjectNode("name", "value");
    try {
        on.getBool();
        QUnit.ok(false);
    }
    catch (e__0) {
    }
    QUnit.equal(true, on.getBool(true));
    QUnit.equal(false, on.getBool(false));
    on = new ObjectNode("name", "1");
    QUnit.equal(true, on.getBool());
    on = new ObjectNode("name", "0");
    QUnit.equal(false, on.getBool());
    on = new ObjectNode("name", "123");
    try {
        on.getBool();
        QUnit.ok(false);
    }
    catch (e__1) {
    }
    QUnit.equal(true, on.getBool(true));
    QUnit.equal(false, on.getBool(false));
    on = new ObjectNode("name", "0x123");
    try {
        on.getBool();
        QUnit.ok(false);
    }
    catch (e__2) {
    }
    QUnit.equal(true, on.getBool(true));
    QUnit.equal(false, on.getBool(false));
    on = new ObjectNode("name", "123.5");
    try {
        on.getBool();
        QUnit.ok(false);
    }
    catch (e__3) {
    }
    QUnit.equal(true, on.getBool(true));
    QUnit.equal(false, on.getBool(false));
    on = new ObjectNode("name", null);
    try {
        on.getBool();
        QUnit.ok(false);
    }
    catch (e__4) {
    }
    QUnit.equal(true, on.getBool(true));
    QUnit.equal(false, on.getBool(false));
    on = new ObjectNode("name", 1);
    QUnit.equal(true, on.getBool(true));
    QUnit.equal(false, on.getBool(false));
    on = new ObjectNode("name", "true");
    QUnit.equal(true, on.getBool(true));
    QUnit.equal(false, on.getBool(false));
});
QUnit.test("testIsStringObject()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal(true, on.isStringObject());
    on = new ObjectNode("name", "1");
    QUnit.equal(true, on.isStringObject());
    on = new ObjectNode("name", "123");
    QUnit.equal(true, on.isStringObject());
    on = new ObjectNode("name", "0x123");
    QUnit.equal(true, on.isStringObject());
    on = new ObjectNode("name", "123.5");
    QUnit.equal(true, on.isStringObject());
    on = new ObjectNode("name", null);
    QUnit.equal(false, on.isStringObject());
    on = new ObjectNode("name", 1);
    QUnit.equal(false, on.isStringObject());
    on = new ObjectNode("name", "true");
    QUnit.equal(true, on.isStringObject());
});
QUnit.test("testIsIntObject()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal(false, on.isIntObject());
    on = new ObjectNode("name", "1");
    QUnit.equal(true, on.isIntObject());
    on = new ObjectNode("name", "123");
    QUnit.equal(true, on.isIntObject());
    on = new ObjectNode("name", "0x123");
    QUnit.equal(false, on.isIntObject());
    on = new ObjectNode("name", "123.5");
    QUnit.equal(false, on.isIntObject());
    on = new ObjectNode("name", null);
    QUnit.equal(false, on.isIntObject());
    on = new ObjectNode("name", 1);
    QUnit.equal(false, on.isIntObject());
    on = new ObjectNode("name", "true");
    QUnit.equal(false, on.isIntObject());
});
QUnit.test("testIsBoolObject()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal(false, on.isBoolObject());
    on = new ObjectNode("name", "0 ");
    QUnit.equal(true, on.isBoolObject());
    on = new ObjectNode("name", "1");
    QUnit.equal(true, on.isBoolObject());
    on = new ObjectNode("name", "123");
    QUnit.equal(false, on.isBoolObject());
    on = new ObjectNode("name", "0x123");
    QUnit.equal(false, on.isBoolObject());
    on = new ObjectNode("name", "123.5");
    QUnit.equal(false, on.isBoolObject());
    on = new ObjectNode("name", null);
    QUnit.equal(false, on.isBoolObject());
    on = new ObjectNode("name", 1);
    QUnit.equal(false, on.isBoolObject());
    on = new ObjectNode("name", "true");
    QUnit.equal(false, on.isBoolObject());
});
QUnit.test("testIsFloatObject()", function () {
    var on;
    on = new ObjectNode("name", "value");
    QUnit.equal(false, on.isFloatObject());
    on = new ObjectNode("name", "0");
    QUnit.equal(true, on.isFloatObject());
    on = new ObjectNode("name", "1");
    QUnit.equal(true, on.isFloatObject());
    on = new ObjectNode("name", "123");
    QUnit.equal(true, on.isFloatObject());
    on = new ObjectNode("name", "0x123");
    QUnit.equal(false, on.isFloatObject());
    on = new ObjectNode("name", "123.5");
    QUnit.equal(true, on.isFloatObject());
    on = new ObjectNode("name", null);
    QUnit.equal(false, on.isFloatObject());
    on = new ObjectNode("name", 1);
    QUnit.equal(false, on.isFloatObject());
});
//# sourceMappingURL=ObjectNodeTest.js.map