import { MathUtil } from './MathUtil';
//module jp.kitec.lib.util
function equal(expect, actual, eps) {
    QUnit.ok(Math.abs(expect - actual) <= eps);
}
QUnit.test("testKirisute()", function () {
    equal(1.0, MathUtil.kirisute(1.5, 1), 0.01);
    equal(-2.0, MathUtil.kirisute(-1.5, 1), 0.01);
    equal(1.1, MathUtil.kirisute(1.125, 2), 0.001);
    equal(-1.2, MathUtil.kirisute(-1.125, 2), 0.001);
    equal(10.0, MathUtil.kirisute(19.925, 0), 0.1);
    equal(-20.0, MathUtil.kirisute(-11.125, 0), 0.1);
    equal(700.0, MathUtil.kirisute(749.925, -1), 1);
    equal(-800.0, MathUtil.kirisute(-720.125, -1), 1);
});
QUnit.test("testCrossProduct()", function () {
    equal(0, MathUtil.crossProduct(0, 0, 1, 0, 1, 0), 0.001);
    equal(1, MathUtil.crossProduct(0, 0, 1, 0, 0, 1), 0.001);
    equal(-1, MathUtil.crossProduct(0, 0, 1, 0, 0, -1), 0.001);
    equal(0, MathUtil.crossProduct(0, 0, 1, 0, -1, 0), 0.001);
    equal(40, MathUtil.crossProduct(0, 0, 1, 0, -20, 40), 0.001);
    equal(0, MathUtil.crossProduct(-2, -2, 0, 0, -4, -4), 0.001);
});
QUnit.test("testGetAnglGapDeg()", function () {
    equal(0, MathUtil.getAnglGapDeg(0, 0), 0.001);
    equal(30, MathUtil.getAnglGapDeg(90, 120), 0.001);
    equal(10, MathUtil.getAnglGapDeg(0, 10), 0.001);
    equal(350, MathUtil.getAnglGapDeg(10, 0), 0.001);
    equal(1, MathUtil.getAnglGapDeg(0, 361), 0.001);
    equal(359, MathUtil.getAnglGapDeg(361, 0), 0.001);
});
QUnit.test("testGetAnglGapRad()", function () {
    equal(0, MathUtil.getAnglGapRad(0, 0), 0.001);
    equal(Math.PI * 2 / 3, MathUtil.getAnglGapRad(Math.PI / 3, Math.PI), 0.001);
    equal(Math.PI / 4, MathUtil.getAnglGapRad(0, Math.PI / 4), 0.001);
    equal(Math.PI / 2, MathUtil.getAnglGapRad(Math.PI / 2, 0), 0.001);
    equal(Math.PI * 0.1, MathUtil.getAnglGapRad(0, Math.PI * 2.1), 0.001);
    equal(Math.PI * 0.1, MathUtil.getAnglGapRad(Math.PI * 2.1, 0), 0.001);
});
QUnit.test("testIsInnerAngl360()", function () {
    QUnit.equal(true, MathUtil.isInnerAngl360(0, 180, 90));
    QUnit.equal(true, MathUtil.isInnerAngl360(0, 180, 90));
});
//# sourceMappingURL=MathUtilTest.js.map