import * as emutils from 'emutils';
export class StringBuilder {
    constructor(str) {
        this.str = str || "";
    }
    append(s) {
        if (typeof s === "string")
            this.str += s;
        else if (typeof s === "number") {
            if (Math.floor(s) === s)
                this.str += s.toString();
            else
                this.str += s.toFixed(4);
        }
        else {
            throw Error(typeof s);
        }
        return this;
    }
    toString() {
        return this.str;
    }
}
export class MyPrintStream {
    constructor() {
        this.size = 0;
        this.lines = [];
    }
    println(line) {
        this.lines.push(line);
    }
    close() {
    }
    getData() {
        let str = this.lines.join("\n");
        let buf = new ArrayBuffer(emutils.lengthBytesUTF8(str));
        let bytes = new Uint8Array(buf);
        emutils.stringToUTF8Array(str, bytes, 0, bytes.length);
        return bytes;
    }
}
//# sourceMappingURL=util.js.map