//module jp.kitec.kwt
/**
 * IRichGraphics用ユーティリティ
 * @author kawae
 * @since 2006/02/03
**/
export var RichGraphicsUtil;
(function (RichGraphicsUtil) {
    RichGraphicsUtil.EPS = 1.0e-3;
    /**
     * 2点が同じ位置にあるか検査
     * TODO:ToolMathと絡めて何処か他へ。
     * @param p1x 点1のX座標
     * @param p1y 点1のY座標
     * @param p2x 点2のX座標
     * @param p2y 点2のY座標
    **/
    function isSame2D(p1x, p1y, p2x, p2y) {
        if (Math.abs(p2x - p1x) < RichGraphicsUtil.EPS && Math.abs(p2y - p1y) < RichGraphicsUtil.EPS)
            return true;
        return false;
    }
    RichGraphicsUtil.isSame2D = isSame2D;
    /**
     * ２Dでの角度の計算
     * TODO:ToolMathと絡めて何処か他へ。
     * @param x1 点１のX座標
     * @param y1 点１のY座標
     * @param x2 点２のX座標
     * @param y2 点２のY座標
     * @return 角度（度）
    **/
    function getAngle2D(x1, y1, x2, y2) {
        var dx;
        var dy;
        var t;
        var a;
        var area;
        dx = x2 - x1;
        dy = y2 - y1;
        if (dx >= 0.0) {
            if (dy >= 0.0)
                area = 0;
            else {
                area = 3;
                t = dx;
                dx = -dy;
                dy = t;
            }
        }
        else {
            if (dy >= 0.0) {
                area = 1;
                t = dx;
                dx = dy;
                dy = -t;
            }
            else {
                area = 2;
                dx = -dx;
                dy = -dy;
            }
        }
        if (dy > dx)
            a = Math.PI / 2.0 - Math.atan(dx / dy);
        else
            a = Math.atan(dy / dx);
        return (a + area * (Math.PI / 2.0)) * (180 / Math.PI);
    }
    RichGraphicsUtil.getAngle2D = getAngle2D;
})(RichGraphicsUtil || (RichGraphicsUtil = {}));
//# sourceMappingURL=RichGraphicsUtil.js.map