import { KDimension } from './KDimension';
import { KArea } from './KArea';
/**
 * キャンバス等のビューポート**/
export declare class KViewPort {
    /**
     * ビューの名前 **/
    mViewName: string;
    /**
     * ビューの最大・最小
     **/
    x1: number;
    y1: number;
    x2: number;
    y2: number;
    /**
     * コンストラクタ
     * @param viewname
     * @author kawae
     * @since 2004/10/02
    **/
    constructor(viewname?: string);
    /**
     * ビューの名前の設定
     * @param s
     * @author kawae
     * @since 2004/10/02
    **/
    setViewPortName(s: string): void;
    /**
     * ビューの名前の取得
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    getViewPortName(): string;
    getX1(): number;
    setX1(x1: number): void;
    getY1(): number;
    setY1(y1: number): void;
    getX2(): number;
    setX2(x2: number): void;
    getY2(): number;
    setY2(y2: number): void;
    /**
     * 表示中心 **/
    getCx(): number;
    getCy(): number;
    getCopy(): KViewPort;
    setViewPort(vp: KViewPort): void;
    resetViewPort(area: KArea, margin: number): void;
    resetViewPort(minx: number, miny: number, maxx: number, maxy: number, margin: number): void;
    /**
     * 画面中心の移動
     * @param cx
     * @param cy
    **/
    setViewCenter(cx: number, cy: number): void;
    dotPerLen(d: KDimension): number;
    /**
     * 実座標から画面座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   実座標値
     * @return  デバイス座標値
    **/
    realToDevX(d: KDimension, x: number): number;
    /**
     * 実座標から画面座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   実座標値
     * @return  デバイス座標値
    **/
    realToDevY(d: KDimension, y: number): number;
    /**
     * 実座標から画面座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   実座標値
     * @return  デバイス座標値
    **/
    realToDevXd(d: KDimension, x: number): number;
    /**
     * 実座標から画面座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   実座標値
     * @return  デバイス座標値
    **/
    realToDevYd(d: KDimension, y: number): number;
    /**
     * 画面座標から実座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   デバイス座標値
     * @return      実座標値
    **/
    devToRealX(d: KDimension, x: number): number;
    /**
     * 画面座標から実座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   デバイス座標値
     * @return      実座標値
    **/
    devToRealY(d: KDimension, y: number): number;
}
