import { KGradientFill } from './KGradientFill';
//module jp.kitec.kwt
export class KRadialGradientFill extends KGradientFill {
    constructor(centerX, centerY, radius, focusXOrFractions, focusYOrColor, fractions, color) {
        var focusX;
        var focusY;
        if (typeof focusXOrFractions == "number") {
            focusX = focusXOrFractions;
            focusY = focusYOrColor;
        }
        else {
            if (typeof focusXOrFractions !== "Array")
                throw new Error();
            if (typeof focusYOrColor !== "Array")
                throw new Error();
            focusX = centerX;
            focusY = centerY;
            fractions = focusXOrFractions;
            color = focusYOrColor;
        }
        super(color, fractions);
        this.mCenterX = centerX;
        this.mCenterY = centerY;
        this.mFocusX = focusX;
        this.mFocusY = focusY;
        this.mRadius = radius;
    }
    get centerX() {
        return this.mCenterX;
    }
    get centerY() {
        return this.mCenterY;
    }
    get focusX() {
        return this.mFocusX;
    }
    get focusY() {
        return this.mFocusY;
    }
    get radius() {
        return this.mRadius;
    }
    encode() {
        var sb = super.encode();
        sb += ";";
        sb += this.mCenterX;
        sb += ";";
        sb += this.mCenterY;
        sb += ";";
        sb += this.mFocusX;
        sb += ";";
        sb += this.mFocusY;
        return sb;
    }
}
//# sourceMappingURL=KRadialGradientFill.js.map