import { KRuntime } from './KRuntime';
//module jp.kitec.kwt
/**
 * @author kawae
 **/
export class KFont {
    constructor(fontname, fonttype, fontsize) {
        this.mFontname = fontname;
        this.mFonttype = fonttype | 0;
        this.mFontsize = fontsize | 0;
    }
    /**
     * フォントタイプ**/
    static get PLAIN() { return 0; }
    static get BOLD() { return 1; }
    static get ITALIC() { return 2; }
    get name() {
        return this.mFontname;
    }
    get style() {
        return this.mFonttype;
    }
    get size() {
        return this.mFontsize;
    }
    get ascent() {
        return this.getFontMetrics(null).getAscent();
    }
    get descent() {
        return this.getFontMetrics(null).getDescent();
    }
    get height() {
        return this.getFontMetrics(null).getHeight();
    }
    stringWidth(s) {
        return this.getFontMetrics(null).stringWidth(s);
    }
    /**
     * 現在の Font オブジェクトを複製し新しいサイズを適用することにより、新しい Font オブジェクトを生成します。
     * @param size
     * @return
    **/
    deriveSize(size) {
        return KRuntime.runtime().getFont(this.mFontname, this.mFonttype, size);
    }
    /**
     * 現在の Font オブジェクトを複製し新しいスタイルを適用することにより、新しい Font オブジェクトを生成します。
     * @param style
     * @return
    **/
    deriveStyle(style) {
        return KRuntime.runtime().getFont(this.mFontname, style, this.mFontsize);
    }
    /**
     * この Font オブジェクトを複製し新しいスタイルおよびサイズを適用することにより、新しい Font オブジェクトを生成します。
     * @param style
     * @param size
     * @return
    **/
    deriveStyleSize(style, size) {
        return KRuntime.runtime().getFont(this.mFontname, style, size);
    }
    hashCode() {
        var prime = 31;
        var result = 1;
        //result = prime * result + ((this.mFontname == null) ? 0 : this.mFontname.hashCode());
        result = prime * result + (this.mFontsize);
        result = prime * result + this.mFonttype;
        return result;
    }
    equals(obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this.mFontname == null) {
            if (other.mFontname != null)
                return false;
        }
        else if (this.mFontname !== other.mFontname)
            return false;
        if (this.mFontsize !== other.mFontsize)
            return false;
        if (this.mFonttype != other.mFonttype)
            return false;
        return true;
    }
    static getFont(fontname, fontstyle, fontsize) {
        return KRuntime.runtime().getFont(fontname, fontstyle, fontsize);
    }
}
//# sourceMappingURL=KFont.js.map