import { ObjectFolder } from '../util/tree/ObjectFolder';
//module jp.kitec.kwt
export class KDimension {
    constructor(widthOrDim, height) {
        if (widthOrDim instanceof KDimension) {
            var dim = widthOrDim;
            this.width = dim.width;
            this.height = dim.height;
            return;
        }
        if (typeof widthOrDim === "number") {
            var width = widthOrDim;
            this.width = width;
            this.height = height;
        }
    }
    hashCode() {
        var prime = 31;
        var result = 1;
        result = prime * result + this.height;
        result = prime * result + this.width;
        return result;
    }
    equals(obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this.height != other.height)
            return false;
        if (this.width != other.width)
            return false;
        return true;
    }
    save(savenode) {
        savenode.setName(KDimension.GEOMNAME);
        ObjectFolder.addNodeInt(savenode, "w", this.width);
        ObjectFolder.addNodeInt(savenode, "h", this.height);
    }
    static readData(datanode, r) {
        var on;
        if ((on = datanode.getNode("w")) != null)
            r.width = on.getInt(0);
        if ((on = datanode.getNode("h")) != null)
            r.height = on.getInt(0);
    }
}
KDimension.GEOMNAME = "DIMENSION";
//# sourceMappingURL=KDimension.js.map