import { KFill } from './KFill';
/**
 * @author kawae**/
export declare class KColor implements KFill {
    /**
     * 明るい黄色**/
    static LIGHT_YELLOW: KColor;
    /**
     * 濃い黄色**/
    static DARK_YELLOW: KColor;
    /**
     * 空色**/
    static SKY_BLUE: KColor;
    /**
     * 水色**/
    static WATER: KColor;
    /**
     * 濃い青**/
    static DARK_BLUE: KColor;
    /**
     * 明るい緑**/
    static LIGHT_GREEN: KColor;
    /**
     * 濃い緑**/
    static DARK_GREEN: KColor;
    /**
     * かなり明るい灰色**/
    static MORELIGHT_GRAY: KColor;
    /**
     * さらに明るい灰色**/
    static SUPERLIGHT_GRAY: KColor;
    /**
     * 明るい灰色**/
    static LIGHT_GRAY2: KColor;
    static WHITE: KColor;
    static LIGHT_GRAY: KColor;
    static GRAY: KColor;
    static DARK_GRAY: KColor;
    static BLACK: KColor;
    static RED: KColor;
    static PINK: KColor;
    static ORANGE: KColor;
    static YELLOW: KColor;
    static GREEN: KColor;
    static MAGENTA: KColor;
    static CYAN: KColor;
    static BLUE: KColor;
    private static SCALE_FACTOR;
    private static MIN_SCALABLE;
    private _argb;
    argb: number;
    /**
     * コンストラクタ
     * @param argb
     **/
    constructor(rgb: number);
    /**
     * コンストラクタ
     * @param argb
     * @param hasAlpha
    **/
    constructor(argb: number, hasAlpha: boolean);
    /**
     * コンストラクタ
     * @param r
     * @param g
     * @param b
    **/
    constructor(r: number, g: number, b: number);
    /**
     * コンストラクタ
     * @param r
     * @param g
     * @param b
     * @param alpha
    **/
    constructor(r: number, g: number, b: number, alpha: number);
    getRed(): number;
    getRGB(): number;
    getGreen(): number;
    getBlue(): number;
    getAlpha(): number;
    darker(): KColor;
    brighter(): KColor;
    /**
     * ARGBを16進数で返す
     * @return
    **/
    encode(): string;
    css(): string;
    hashCode(): number;
    equals(obj: KColor): boolean;
    /**
     * カンマ区切りのRGBからColorを作成
     * @param s
     * @return
     * @author kawae
     * @since 2004/10/12
    **/
    static getColorFromRGBString(s: string): KColor;
    /**
     * カンマ区切りのRGB文字列の取得
     * @param c
     * @return
     * @author kawae
     * @since 2004/11/05
    **/
    static getColorRGBString(c: KColor): string;
    /**
     * nullを許容する比較
     * @param c1
     * @param c2
     * @return
    **/
    static isDiff(c1: KColor, c2: KColor): boolean;
    static equals(c1: KColor, c2: KColor): boolean;
    /**
     * アルファ値を使ってKColorオブジェクトを作成する
     * @param val
     * @return
    **/
    static decode(val: string): KColor;
    toString(): string;
}
