import { KArea } from './KArea';
import { ObjectFolder } from '../util/tree/ObjectFolder';
//module jp.kitec.kwt
QUnit.test("testMaximize()", function () {
    var a = new KArea();
    a.maximize();
    QUnit.equal(a.minX, Number.POSITIVE_INFINITY);
    QUnit.equal(a.maxX, Number.NEGATIVE_INFINITY);
    QUnit.equal(a.minY, Number.POSITIVE_INFINITY);
    QUnit.equal(a.maxY, Number.NEGATIVE_INFINITY);
});
QUnit.test("testSetAreaFloatFloatFloatFloat()", function () {
    var a = new KArea();
    a.setArea(100.0, 200.0, 300.0, 400.0);
    QUnit.equal(a.minX, 100.0);
    QUnit.equal(a.minY, 200.0);
    QUnit.equal(a.maxX, 300.0);
    QUnit.equal(a.maxY, 400.0);
    a.setArea(300.0, 400.0, 100.0, 200.0);
    QUnit.equal(a.minX, 100.0);
    QUnit.equal(a.minY, 200.0);
    QUnit.equal(a.maxX, 300.0);
    QUnit.equal(a.maxY, 400.0);
});
QUnit.test("testSetAreaArea()", function () {
    var a = new KArea();
    a.setArea(100.0, 200.0, 300.0, 400.0);
    var b = new KArea();
    b.setArea(a);
    QUnit.equal(a.minX, b.minX);
    QUnit.equal(a.minY, b.minY);
    QUnit.equal(a.maxX, b.maxX);
    QUnit.equal(a.maxY, b.maxY);
});
QUnit.test("testUpdateMinMaxArea()", function () {
    var a = new KArea();
    a.setArea(100.0, 200.0, 300.0, 400.0);
    var b = new KArea();
    b.setArea(10.0, 20.0, 100.0, 300.0);
    a.updateMinMax(b);
    QUnit.equal(a.minX, 10.0);
    QUnit.equal(a.minY, 20.0);
    QUnit.equal(a.maxX, 300.0);
    QUnit.equal(a.maxY, 400.0);
    b.setArea(1000.0, 1000.0, 2000.0, 3000.0);
    a.updateMinMax(b);
    QUnit.equal(a.minX, 10.0);
    QUnit.equal(a.minY, 20.0);
    QUnit.equal(a.maxX, 2000.0);
    QUnit.equal(a.maxY, 3000.0);
});
QUnit.test("testUpdateMinMaxFloatFloat()", function () {
    var a = new KArea();
    a.maximize();
    a.updateMinMax(10.0, 20.0);
    QUnit.equal(a.minX, 10.0);
    QUnit.equal(a.minY, 20.0);
    QUnit.equal(a.maxX, 10.0);
    QUnit.equal(a.maxY, 20.0);
    a.updateMinMax(-10.0, 100.5);
    QUnit.equal(a.minX, -10.0);
    QUnit.equal(a.minY, 20.0);
    QUnit.equal(a.maxX, 10.0);
    QUnit.equal(a.maxY, 100.5);
});
QUnit.test("testIsInner()", function () {
    var a = new KArea();
    a.setArea(100.0, 200.0, 300.0, 400.0);
    QUnit.equal(true, a.isInner(200.0, 300.0));
    QUnit.equal(true, a.isInner(100.0, 300.0));
    QUnit.equal(true, a.isInner(300.0, 300.0));
    QUnit.equal(true, a.isInner(200.0, 200.0));
    QUnit.equal(true, a.isInner(200.0, 400.0));
    QUnit.equal(false, a.isInner(0.0, 300.0));
    QUnit.equal(false, a.isInner(301.0, 300.0));
    QUnit.equal(false, a.isInner(200.0, 100.0));
    QUnit.equal(false, a.isInner(200.0, 500.0));
    QUnit.equal(false, a.isInner(0.0, 0.0));
});
//QUnit.test("testHashCode()", function () {
//    var a: KArea = new KArea();
//    a.setArea(100.0, 200.0, 300.0, 400.0);
//    a.hashCode();
//    var a2: KArea = new KArea();
//    a2.setArea(100.0, 200.0, 300.0, 400.0);
//    QUnit.equal(a.hashCode(), a2.hashCode());
//    var c: KArea = new KArea();
//    c.setArea(0.0, 200.0, 300.0, 400.0);
//    QUnit.equal(false, a.hashCode() == c.hashCode());
//});
QUnit.test("testEquals()", function () {
    var a = new KArea();
    a.setArea(100.0, 200.0, 300.0, 400.0);
    QUnit.equal(true, a.equals(a));
    //QUnit.equal(false, a.equals(new Object()));
    var a2 = new KArea();
    a2.setArea(100.0, 200.0, 300.0, 400.0);
    QUnit.equal(true, a.equals(a2));
    var c = new KArea();
    c.setArea(0.0, 200.0, 300.0, 400.0);
    QUnit.equal(false, a.equals(c));
});
QUnit.test("testSet()", function () {
    var a = new KArea();
    a.setArea(100.0, 200.0, 300.0, 400.0);
    var a2 = new KArea();
    a2.setArea(a);
    QUnit.ok(a.equals(a2));
    QUnit.equal(100.0, a.minX);
    QUnit.equal(200.0, a.minY);
    QUnit.equal(300.0, a.maxX);
    QUnit.equal(400.0, a.maxY);
});
QUnit.test("testSaveRead()", function () {
    var a = new KArea();
    a.setArea(100.0, 200.0, 300.0, 400.0);
    var of = new ObjectFolder("");
    a.save(of);
    var read = new KArea();
    KArea.readData(of, read);
    QUnit.ok(a.equals(read));
});
//# sourceMappingURL=KAreaTest.js.map