import { K2DPathFigureLine } from './K2DPathFigureLine';
/**
 * ２次元円弧要素のインターフェース
 * @author kawae
 * @since 2006/01/13
**/
export interface K2DPathFigureArc extends K2DPathFigureLine {
    /**
     * 円弧の中心点のＸ座標値を取得する。
     * Coded on 2005/07/22
     * @return	円弧の中心点のＸ座標値
    **/
    getCX(): number;
    /**
     * 円弧の中心点のＹ座標値を取得する。
     * Coded on 2005/07/22
     * @return	円弧の中心点のＹ座標値
    **/
    getCY(): number;
    /**
     * 円弧の半径を取得する。
     * Coded on 2005/07/28
     * @return double	円弧の半径
    **/
    getRadius(): number;
    /**
     * 時計回り円弧かどうかの問い合わせをする。
     * Coded on 2005/07/28
     * @return boolean	時計回りの場合true
    **/
    isCw(): boolean;
    /**
     * 円弧の中心点のＸ座標値をセットする。
     * Coded on 2005/07/25
     * @param x	円弧の中心点のＸ座標値
    **/
    setCX(x: number): void;
    /**
     * 円弧の中心点のＹ座標値をセットする。
     * Coded on 2005/07/25
     * @param y	円弧の中心点のＹ座標値
    **/
    setCY(y: number): void;
    /**
     * 時計回り円弧の場合trueをセットする。
     * Coded on 2005/07/28
     * @param cw	時計回りの場合true
    **/
    setCw(cw: boolean): void;
    /**
     * 円弧の半径をセットする。
     * Coded on 2005/09/13
     * @param radius	円弧の半径
    **/
    setRadius(radius: number): void;
}
