import { K2DFigureType } from '../geom/K2DFigureType';
import { Vector2d } from 'vecmathjs';
//module jp.kitec.vecmath
/**
 * @author matsuzaki**/
export class KVector2d extends Vector2d {
    constructor(a, b) {
        if (a === undefined) {
            super();
        }
        else if (typeof a == "number") {
            super(a, b);
        }
        else if (Array.isArray(a)) {
            super(a[0], a[1]);
        }
        else if (a.hasOwnProperty("x")) {
            super(a.x, a.y);
        }
        else {
            throw new Error();
        }
    }
    setXY(x, y) {
        this.x = x;
        this.y = y;
    }
    getType() {
        return K2DFigureType.POINT;
    }
    setX(x) {
        this.x = x;
    }
    setY(y) {
        this.y = y;
    }
    getX() {
        return this.x;
    }
    getY() {
        return this.y;
    }
}
//# sourceMappingURL=KVector2d.js.map