import * as emutils from 'emutils';
import { ObjectNode } from '../tree/ObjectNode';
import { ObjectFolder } from '../tree/ObjectFolder';
import { Base64Encoder } from '../../io/Base64Encoder';
import { XMLManager } from './XMLManager';
//module jp.kitec.lib.util.xml
/**
 * @author kawae
 * XMLWriterを例外をcatchしないように修正したもの
 **/
export class XMLWriter {
    /**
     * ライト
     * @param f
     * @param space
     * @param w
     * @throws Exception
    **/
    static write(f, space) {
        var s = [""];
        XMLWriter.write_(f, space, s);
        return s[0];
    }
    //static write(f: ObjectNode, space: string, o: Writer): void /*IOException*/ {
    //    XMLWriter.write_(f, space, o);
    //}
    /**
     * @param f
     * @param space
     * @param o
     * @throws Exception
     * @author kawae
     * @since 2005/12/09
    **/
    static write_(f, space, o) {
        if (f instanceof ObjectFolder) {
            var of = f;
            var hasFolder = false;
            var hasNode = false;
            for (let i = 0; i < of.getChildren().length; i++) {
                if (of.getChildren()[i] instanceof ObjectFolder) {
                    hasFolder = true;
                }
                else if (of.getChildren()[i] instanceof ObjectNode) {
                    hasNode = true;
                }
            }
            if (hasNode)
                XMLWriter.print(o, space + "<" + of.getName());
            else {
                if (of.getChildren() == null || of.getChildren().length == 0) {
                    XMLWriter.println(o, space + "<" + of.getName() + "/>");
                    return;
                }
                XMLWriter.println(o, space + "<" + of.getName() + ">");
            }
            for (let i = 0; i < of.getChildren().length; i++) {
                if (!(of.getChildren()[i] instanceof ObjectFolder))
                    XMLWriter.write_(of.getChildren()[i], space + " ", o);
            }
            if (hasNode && !hasFolder)
                XMLWriter.println(o, "/>");
            else if (hasNode)
                XMLWriter.println(o, ">");
            for (let i = 0; i < of.getChildren().length; i++) {
                if (of.getChildren()[i] instanceof ObjectFolder)
                    XMLWriter.write_(of.getChildren()[i], space + " ", o);
            }
            if (hasFolder)
                XMLWriter.println(o, space + "</" + of.getName() + ">");
        }
        else {
            var on = f;
            if (on.getObject() != null) {
                var str = on.getString();
                var enc64 = false;
                for (let element of XMLManager.ENC_64_CHARS) {
                    if (str.indexOf(element) >= 0) {
                        enc64 = true;
                        break;
                    }
                }
                if (enc64) {
                    let bytes = new Array(emutils.lengthBytesUTF8(str));
                    let len = emutils.stringToUTF8Array(str, bytes, 0, bytes.length);
                    bytes.length = len;
                    str = XMLManager.BASE64_TAG_BRGIN + Base64Encoder.encode(bytes) + XMLManager.BASE64_TAG_END;
                }
                XMLWriter.print(o, " " + on.getName() + "=\"" + str + "\"");
            }
            else {
                XMLWriter.print(o, " " + on.getName() + "=\"" + on.getObject() + "\"");
            }
        }
    }
    /**
     * @param target
     * @param message
     * @author kawae
     * @since 2005/12/09
    **/
    static print(target, message) {
        target[0] += message;
    }
    /**
     * @param target
     * @param message
     * @author kawae
     * @since 2005/12/09
    **/
    static println(target, message) {
        target[0] += message + "\n";
    }
}
//# sourceMappingURL=XMLWriter.js.map