//import { error } from '../../common'
import { XMLParser } from './XMLParser';
//module jp.kitec.lib.util.xml
/**
 * XML 管理クラス。
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
export class XMLManager {
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML データ入力オブジェクト
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    //load(in_$ : AbstFile) : boolean {
    //    var xml : XMLParser = new XMLParser();
    //    this.mObjFolder = xml.load(in_$);
    //    return (this.mObjFolder != null) ? true : false;
    //}
    //load(in_$ : AbstFile, encode : string) : boolean {
    //    var xml : XMLParser = new XMLParser();
    //    this.mObjFolder = xml.load(in_$, encode);
    //    return (this.mObjFolder != null) ? true : false;
    //}
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML データ入力ストリーム
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    load(data) {
        var xml = new XMLParser();
        this.mObjFolder = xml.load(data);
        return (this.mObjFolder != null) ? true : false;
    }
    loadIntArray(data) {
        var xml = new XMLParser();
        this.mObjFolder = xml.loadIntArray(data);
        return (this.mObjFolder != null) ? true : false;
    }
    /**
     * XML を表す木構造のデータを返す。
     * @return		木構造データ
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    getTree() {
        return this.mObjFolder;
    }
}
XMLManager.ENC_64_CHARS = ["<", ">", "\""];
XMLManager.BASE64_TAG_BRGIN = "__BEGIN_BASE64ENCODED__";
XMLManager.BASE64_TAG_END = "__END_BASE64ENCODED__";
//# sourceMappingURL=XMLManager.js.map