import { ObjectFolder } from '../tree/ObjectFolder';
/**
 * XML 管理クラス。
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
export declare class XMLManager {
    static ENC_64_CHARS: string[];
    static BASE64_TAG_BRGIN: string;
    static BASE64_TAG_END: string;
    /**
     * XML ファイルからの読み込みデータ（木構造） **/
    mObjFolder: ObjectFolder;
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML データ入力オブジェクト
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML データ入力ストリーム
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    load(data: string): boolean;
    loadIntArray(data: number[] | Uint8Array): boolean;
    /**
     * XML を表す木構造のデータを返す。
     * @return		木構造データ
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    getTree(): ObjectFolder;
}
