import { PdfCommand } from './PdfCommand';
import { PdfRichGraphicsAdapter } from './PdfRichGraphicsAdapter';
//module option.pdf
/**
 * @author kawae
 * @since 2004/11/09
**/
export class PdfRichGraphics extends PdfRichGraphicsAdapter {
    constructor(file) {
        super(null);
        this.pdf = new PdfCommand(file);
    }
    //public constructor(file: string, code?: string) {
    //    super(null);
    //    this.pdf = new PdfCommand(file);
    //}
    setFontEmbed(flag) {
        this.mFontEmbed = flag;
    }
    startPage(size, direction) {
        this.pdf.setPageInfo(size, direction);
        this.pdf.setUserCoordinateDirectionY(PdfCommand.BOTTOM_TO_TOP);
        this.mGraphics = this.pdf.getGraphics();
        this.mGraphics.setFontEmbed(this.mFontEmbed);
    }
    endPage() {
        this.mGraphics.dispose();
    }
}
//# sourceMappingURL=PdfRichGraphics.js.map