import { KDimension } from '../kwt/KDimension';
import { PdfGraphics } from './PdfGraphics';
import { MyPrintStream } from './util';
/**
 * PDF コマンドを作成する。<BR> 作成方法は、<BR>　1.当クラスの生成する。<BR>
 * 　2.PDF 出力用の Graphics を取得する。（新たなページの開始）<BR>
 * 　3.Graphics のメソッドを使用しデータを書き込む<BR>
 * 　4.Graphics を破棄する。（ページの終了）<BR>
 * 　5.PDF 出力を終了する。<BR>以上で、PDF コマンドが作成される。<BR> 必要に応じて、2 ～ 3 を繰り返し、複数ページへの出力を行う。<BR> 作成された PDF コマンドデータは、getCommand() にて取得する。<BR> デフォルトの用紙サイズは、A4 の縦方向。変更する場合は、 setPageInfo(String, boolean) を実行する。
 * @since 　2004/01/20
 * @author　fujita
 * @version 2004/01/20Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
export declare class PdfCommand {
    /**
     * PDF ページの印刷先として A1 用紙を使用することを示す **/
    static A1: number;
    /**
     * PDF ページの印刷先として A2 用紙を使用することを示す **/
    static A2: number;
    /**
     * PDF ページの印刷先として A3 用紙を使用することを示す **/
    static A3: number;
    /**
     * PDF ページの印刷先として A4 用紙を使用することを示す **/
    static A4: number;
    /**
     * PDF ページの印刷先として A5 用紙を使用することを示す **/
    static A5: number;
    /**
     * PDF ページの印刷先として A6 用紙を使用することを示す **/
    static A6: number;
    /**
     * PDF ページの印刷先として A7 用紙を使用することを示す **/
    static A7: number;
    /**
     * PDF ページの印刷先として A8 用紙を使用することを示す **/
    static A8: number;
    /**
     * PDF ページの印刷先として A9 用紙を使用することを示す **/
    static A9: number;
    /**
     * PDF ページの印刷先として A10 用紙を使用することを示す **/
    static A10: number;
    /**
     * PDF ページの印刷先として B1 用紙を使用することを示す **/
    static B1: number;
    /**
     * PDF ページの印刷先として B2 用紙を使用することを示す **/
    static B2: number;
    /**
     * PDF ページの印刷先として B3 用紙を使用することを示す **/
    static B3: number;
    /**
     * PDF ページの印刷先として B4 用紙を使用することを示す **/
    static B4: number;
    /**
     * PDF ページの印刷先として B5 用紙を使用することを示す **/
    static B5: number;
    /**
     * PDF ページの印刷先として B6 用紙を使用することを示す **/
    static B6: number;
    /**
     * PDF ページの印刷先として B7 用紙を使用することを示す **/
    static B7: number;
    /**
     * PDF ページの印刷先として B8 用紙を使用することを示す **/
    static B8: number;
    /**
     * PDF ページの印刷先として B9 用紙を使用することを示す **/
    static B9: number;
    /**
     * PDF ページの印刷先として B10 用紙を使用することを示す **/
    static B10: number;
    /**
     * PDF のページ印刷先の物理媒体の幅と高さ用のインデックス **/
    static MEDIA_SIZE_INDEXES: string[];
    /**
     * PDF のページ印刷先の物理媒体の幅、および高さ（単位：mm） **/
    static MEDIA_SIZE: number[][];
    /**
     * 用紙を縦方向に使用することを示す **/
    static PORTRAIT: number;
    /**
     * 用紙を横方向に使用することを示す **/
    static LANDSCAPE: number;
    /**
     * 印刷先の DPI のデフォルト値 **/
    static DEFAULT_DPI: number;
    /**
     * ビューポートの最大数のデフォルト値 **/
    static DEFAULT_VIEWPORT_MAX: number;
    /**
     * ユーザ座標の y 軸が上から下へ方向へ伸びることを示す（デフォルト） **/
    static TOP_TO_BOTTOM: number;
    /**
     * ユーザ座標の y 軸が下から上へ方向へ伸びることを示す **/
    static BOTTOM_TO_TOP: number;
    /**
     * PDF コマンド出力用グラフィックス **/
    mPdfGraphics: PdfGraphics;
    /**
     * PDF コマンド、およびイメージを累積 **/
    mTable: Map<string, any>;
    /**
     * PDF コマンドを累積 **/
    /**
     * PDF コマンドを累積 **/
    mOutStream: MyPrintStream;
    /**
     * PDF 出力ファイル名 **/
    mFileName: string;
    /**
     * ページ数 **/
    mPageCount: number;
    /**
     * PDF が開かれているか否かを示す **/
    mIsPDFOpened: boolean;
    /**
     * 出力ファイルが開かれているか否かを示す **/
    mIsFileOpened: boolean;
    /**
     * 出力ページが開かれているか否かを示す **/
    mIsPageStarted: boolean;
    /**
     * 現在のページのサイズ **/
    mPageSize: number;
    /**
     * 現在のページのページ方向 **/
    mDirection: number;
    /**
     * 現在のページの 1 インチ当たりドット数 **/
    mDpi: number;
    /**
     * 現在の出力したイメージの数（イメージコマンドのイメージ名として使用） **/
    mImageCount: number;
    /**
     * ユーザ座標 **/
    mUserMinX: number;
    mUserMinY: number;
    mUserMaxX: number;
    mUserMaxY: number;
    /**
     * ビューポート座標 **/
    mViewMinX: number[];
    mViewMinY: number[];
    mViewMaxX: number[];
    mViewMaxY: number[];
    /**
     * ビューポートの最大数 **/
    mViewportMax: number;
    /**
     * 現在のビューポートの数 **/
    mViewportCount: number;
    /**
     * 現在のビューポート **/
    mCurrentViewport: number;
    /**
     * 出力先となる PDF ページの現在の幅 **/
    mPageWidth: number;
    /**
     * 出力先となる PDF ページの現在の高さ **/
    mPageHeight: number;
    /**
     * フォーマットを使用する場合のフォーマット名 **/
    mFormats: Array<string>;
    /**
     * ユーザ座標の y 軸の方向 **/
    mUserCoordDirY: number;
    count: number;
    /**
     * 書き出し文字コード(060110) **/
    /**
     * PDF コマンドを作成するための PdfCommand を構築する。
     * @since   2004/01/20
     * @author  fujita
     * @version 2004/01/20
    **/
    constructor(fileName: string);
    /**
     * 新しい PDF コマンドを出力用に開く。<BR>
     * @see #closePdf()
     * @since   2004/01/20
     * @author  fujita
     * @version 2004/01/20
    **/
    openPdf(): void;
    /**
     * 現在、出力中の PDF コマンドを閉じる。
     * @see #openPdf()
     * @since   2004/01/20
     * @author  fujita
     * @version 2004/01/20
    **/
    closePdf(): void;
    /**
     * ページのサイズなどのページに関する情報を設定する。<BR> このとき、ユーザ座標は、ページサイズと同じサイズに設定される。
     * @param pageSize	出力するページのサイズ
     * @param direction	ページを使用する方向（縦、または横）
     * @param dpi			1 インチ当たりのドット数
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    setPageInfo(pageSize: number, direction: number, dpi?: number): void;
    /**
     * ページのサイズなどのページに関する情報設定の実処理を行う。
     * @param pageSize	出力するページのサイズ
     * @param direction	ページを使用する方向（縦、または横）
     * @param dpi			1 インチ当たりのドット数
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    setPageInfomation(pageSize: number, direction: number, dpi: number): void;
    /**
     * 現在、出力用に開かれている PDF ファイルへの出力を終了し、 PDF ファイルの作成を行う。<BR>
     * @return		ファイルが正常に作成された場合、作成されたファイル名。そうでない場合は、null
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    end(): void;
    /**
     * 指定されたファイルを新たな PDF の出力ファイルとして開く。<BR> 事前に、openPdf を実行し、PDF コマンドが開く必要がある。
     * @param fileName	PDF を出力するファイル名
     * @see #closeFile()
     * @since   2004/01/20
     * @author  fujita
     * @version 2004/01/20
    **/
    openFile(fileName: string): void;
    /**
     * 現在の出力ファイルを閉じる。<BR> このとき、出力中のページもあわせて閉じる。
     * @see #openFile(String)
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    closeFile(): void;
    /**
     * 指定されたページのサイズ、および印刷方向で新しいページを作成する。
     * @param pageSize	"A4", "A3" など出力するページのサイズ
     * @param direction	ページの使用方向
     * @see #endPage()
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    startPage(pageSize: string, direction: number): void;
    /**
     * 現在の出力中のページを閉じる。
     * @see #startPage()
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    endPage(): void;
    /**
     * 指定されたフォーマットを、ページのフォーマットとして設定する。
    
     * formatが省略された場合、現在、設定されているフォーマットをもとに、 PDF フォーマットコマンドを作成する。<BR>
     * フォーマットが null の場合、フォーマットコマンドは 作成されない。
     * @param format	フォーマット。null を指定した場合は、以前、設定されていたフォーマットは クリアされる。
     * @since		2004/02/05
     * @author		fujita
     * @version	2004/02/05
    **/
    setFormat(format?: string): void;
    /**
     * 指定されたフォーマットを、現在のフォーマットに追加する。
     * @param format	フォーマット。null を指定した場合は、フォーマットは設定されない。
     * @since		2004/02/05
     * @author		fujita
     * @version	2004/02/05
    **/
    addFormat(format: string): void;
    /**
     * PDF コマンドを出力するための Graphics を返す。
     * @return		PDF コマンド出力用 Graphics
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    getGraphics(): PdfGraphics;
    /**
     * 現在、書き込まれた PDF コマンドデータを返す。
     * @return		PDF コマンドデータ
     * @since		2004/01/20
     * @author		fujita
     * @version	2004/01/20
    **/
    getData(): Map<string, Uint8Array>;
    /**
     * 現在の出力対象となるイメージ名を返す。<BR> この名前を、イメージ出力時のイメージ名として設定する。
     * @return	イメージ名
     * @since   2004/01/21
     * @author  fujita
     * @version 2004/01/21
    **/
    getNextImageName(): string;
    /**
     * ページの大きさをミリ単位で返す。
     * @return		ページの大きさ
     * @since		2004/01/23
     * @author		fujita
     * @version	2004/01/23
    **/
    getPageDimension(): KDimension;
    /**
     * 指定された最大数でビューポートを、新たに作成する。
     * @param max	ビューポートの最大数
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    createViewport(max: number): void;
    /**
     * 現在のすべてのビューポートを初期状態へ戻す。
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    resetViewport(): void;
    /**
     * 指定されたサイズを、現在のビューポートのサイズとして設定する。
     * @param x1	ビューポートの x 成分の最小値
     * @param y1	ビューポートの y 成分の最小値
     * @param x2	ビューポートの x 成分の最大値
     * @param y2	ビューポートの y 成分の最大値
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    setViewport(x1: number, y1: number, x2: number, y2: number): void;
    /**
     * 指定されたサイズを、新たなユーザ座標のサイズとして設定する。
     * @param x1	ユーザ座標の x 成分の最小値
     * @param y1	ユーザ座標の y 成分の最小値
     * @param x2	ユーザ座標の x 成分の最大値
     * @param y2	ユーザ座標の y 成分の最大値
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    setUserCoordinate(x1: number, y1: number, x2: number, y2: number): void;
    /**
     * ユーザ座標の y 軸の伸びる方向を設定する。
     * @param dir		上から下へ伸びる場合、TOP_TO_BOTTOM。下から上へ伸びる場合は、BOTTOM_TOP_TO
     * @see #getUserCoordinateDirectionY()
     * @since		2004/02/09
     * @author		fujita
     * @version	2004/02/09
    **/
    setUserCoordinateDirectionY(dir: number): void;
    /**
     * 現在のユーザ座標の y 軸の伸びる方向を返す。
     * @return		dir		上から下へ伸びる場合、TOP_TO_BOTTOM。下から上へ伸びる場合は、BOTTOM_TOP_TO
     * @see #setUserCoordinateDirectionY(int)
     * @since		2004/02/09
     * @author		fujita
     * @version	2004/02/09
    **/
    getUserCoordinateDirectionY(): number;
    /**
     * 指定されたサイズを、新たな PDF の出力ページのサイズとして設定する。
     * @param x1	PDF の出力ページの x 成分の最小値
     * @param y1	PDF の出力ページの y 成分の最小値
     * @param x2	PDF の出力ページの x 成分の最大値
     * @param y2	PDF の出力ページの y 成分の最大値
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    setPageDimension(width: number, height: number): void;
    /**
     * 指定されたユーザ座標の幅をページ座標の幅へ変換する。
     * @param w	ユーザ座標の幅
     * @return		ページ座標の幅
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    userWidthToPageWidth(w: number): number;
    /**
     * ユーザ座標の高さをページ座標の高さへ変換する。
     * @param h	ユーザ座標の高さ
     * @return		ページ座標の高さ
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    userHeightToPageHeight(h: number): number;
    /**
     * ユーザ座標の x 成分をページ座標の x 成分へ変換する。
     * @param x	ユーザ座標の x 成分
     * @return		ページ座標の x 成分
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    userXToPageX(x: number): number;
    /**
     * ユーザ座標の y 成分をページ座標の y 成分へ変換する。
     * @param y	ユーザ座標の y 成分
     * @return		ページ座標の y 成分
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    userYToPageY(y: number): number;
    /**
     * ユーザ座標の x 成分をビューポートの x 成分へ変換する。
     * @param x	ユーザ座標の x 成分
     * @return		ビューポートの x 成分
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    userXToViewX(x: number): number;
    /**
     * ユーザ座標の y 成分をビューポートの y 成分へ変換する。
     * @param y	ユーザ座標の y 成分
     * @return		ビューポートの y 成分
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    userYToViewY(y: number): number;
    /**
     * ビューポートの x 成分をページ座標の x 成分へ変換する。
     * @param x	ビューポートの x 成分
     * @return		ページ座標の x 成分
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    viewXToPageX(x: number): number;
    /**
     * ビューポートの y 成分をページ座標の y 成分へ変換する。
     * @param y	ビューポートの y 成分
     * @return		ページ座標の y 成分
     * @since		2004/02/04
     * @author		fujita
     * @version	2004/02/04
    **/
    viewYToPageY(y: number): number;
    /**
     * 指定されたデータを PDF コマンドとして書き込む。
     * @param data	PDF コマンドデータ
     * @since   2004/01/20
     * @author  fujita
     * @version 2004/01/20
    **/
    draw(data: string | number[]): string;
    /**
     * PDF コマンドへの出力できるか判定する。
     * @return		ファイルのオープン等が正常に行われ出力できる状態の場合、true。出力できない場合は、false
     * @since		2004/01/30
     * @author		fujita
     * @version	2004/01/30
    **/
    canWrite(): boolean;
}
