import { KArea } from './KArea';
//module jp.kitec.kwt
/**
 * キャンバス等のビューポート**/
export class KViewPort {
    /**
     * コンストラクタ
     * @param viewname
     * @author kawae
     * @since 2004/10/02
    **/
    constructor(viewname = "") {
        this.x1 = this.y1 = this.x2 = this.y2 = 0;
        this.mViewName = viewname;
    }
    /**
     * ビューの名前の設定
     * @param s
     * @author kawae
     * @since 2004/10/02
    **/
    setViewPortName(s) {
        this.mViewName = s;
    }
    /**
     * ビューの名前の取得
     * @return
     * @author kawae
     * @since 2004/10/02
    **/
    getViewPortName() {
        return this.mViewName;
    }
    getX1() {
        return this.x1;
    }
    setX1(x1) {
        this.x1 = x1;
    }
    getY1() {
        return this.y1;
    }
    setY1(y1) {
        this.y1 = y1;
    }
    getX2() {
        return this.x2;
    }
    setX2(x2) {
        this.x2 = x2;
    }
    getY2() {
        return this.y2;
    }
    setY2(y2) {
        this.y2 = y2;
    }
    /**
     * 表示中心 **/
    getCx() {
        return (this.x1 + this.x2) / 2;
    }
    getCy() {
        return (this.y1 + this.y2) / 2;
    }
    getCopy() {
        var vp = new KViewPort(this.mViewName);
        vp.x1 = this.x1;
        vp.y1 = this.y1;
        vp.x2 = this.x2;
        vp.y2 = this.y2;
        return vp;
    }
    setViewPort(vp) {
        this.x1 = vp.x1;
        this.y1 = vp.y1;
        this.x2 = vp.x2;
        this.y2 = vp.y2;
    }
    resetViewPort(minxOrArea, minyOrMargin, maxx, maxy, margin) {
        if (minxOrArea instanceof KArea) {
            var area = minxOrArea;
            margin = minyOrMargin;
            this.x1 = area.minX - margin;
            this.y1 = area.minY - margin;
            this.x2 = area.maxX + margin;
            this.y2 = area.maxY + margin;
        }
        else {
            if (typeof minxOrArea !== "number" || typeof minyOrMargin !== "number")
                throw new Error();
            var minx = minxOrArea;
            var miny = minyOrMargin;
            this.x1 = minx - margin;
            this.y1 = miny - margin;
            this.x2 = maxx + margin;
            this.y2 = maxy + margin;
        }
    }
    /**
     * 画面中心の移動
     * @param cx
     * @param cy
    **/
    setViewCenter(cx, cy) {
        var offsetx = cx - this.getCx();
        var offsety = cy - this.getCy();
        this.x1 += offsetx;
        this.x2 += offsetx;
        this.y1 += offsety;
        this.y2 += offsety;
    }
    dotPerLen(d) {
        var ww = d.width / (this.x2 - this.x1);
        var wh = d.height / (this.y2 - this.y1);
        return ww < wh ? ww : wh;
    }
    /**
     * 実座標から画面座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   実座標値
     * @return  デバイス座標値
    **/
    realToDevX(d, x) {
        return Math.round(this.realToDevXd(d, x));
    }
    /**
     * 実座標から画面座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   実座標値
     * @return  デバイス座標値
    **/
    realToDevY(d, y) {
        return Math.round(this.realToDevYd(d, y));
    }
    /**
     * 実座標から画面座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   実座標値
     * @return  デバイス座標値
    **/
    realToDevXd(d, x) {
        return (x - this.getCx()) * this.dotPerLen(d) + d.width / 2.0;
    }
    /**
     * 実座標から画面座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   実座標値
     * @return  デバイス座標値
    **/
    realToDevYd(d, y) {
        return d.height - ((y - this.getCy()) * this.dotPerLen(d) + d.height / 2.0);
    }
    /**
     * 画面座標から実座標へ（ｘ）
     * @param d   画面サイズ
     * @param x   デバイス座標値
     * @return      実座標値
    **/
    devToRealX(d, x) {
        return (x - d.width / 2.0) / this.dotPerLen(d) + this.getCx();
    }
    /**
     * 画面座標から実座標へ（ｙ）
     * @param d   画面サイズ
     * @param y   デバイス座標値
     * @return      実座標値
    **/
    devToRealY(d, y) {
        return (d.height / 2.0 - y) / this.dotPerLen(d) + this.getCy();
    }
}
//# sourceMappingURL=KViewPort.js.map