import { ObjectFolder } from '../util/tree/ObjectFolder';
import { MathUtil } from '../util/MathUtil';
import { Point2d, Vector2d } from 'vecmathjs';
//module jp.kitec.kwt
export class KRotatedArea {
    constructor() {
        this.center = new Point2d();
        this.size = new Vector2d();
        this.rotation = 0;
    }
    static get GEOMNAME() { return "ROTATEDAREA"; }
    set(a) {
        this.center.set_tuple(a.center);
        this.size.set_tuple(a.size);
        this.rotation = a.rotation;
    }
    getCenter() {
        return this.center;
    }
    setCenter(center) {
        this.center.set_tuple(center);
    }
    getSize() {
        return this.size;
    }
    setSize(size) {
        this.size.set_tuple(size);
    }
    getRotation() {
        return this.rotation;
    }
    setRotation(rotation) {
        this.rotation = rotation;
    }
    updateMinMax(area) {
        var sin = Math.sin(this.rotation);
        var cos = Math.cos(this.rotation);
        area.updateMinMax(this.center.x + this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin + this.size.y / 2 * cos);
        area.updateMinMax(this.center.x + this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin - this.size.y / 2 * cos);
        area.updateMinMax(this.center.x - this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin - this.size.y / 2 * cos);
        area.updateMinMax(this.center.x - this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin + this.size.y / 2 * cos);
    }
    getDirX() {
        return new Vector2d(Math.cos(this.rotation), Math.sin(this.rotation));
    }
    getDirY() {
        return new Vector2d(Math.cos(this.rotation + Math.PI / 2), Math.sin(this.rotation + Math.PI / 2));
    }
    distanceTo(x, y) {
        var cx = x - this.center.x;
        var cy = y - this.center.y;
        var p = new Vector2d(cx, cy);
        var dx = this.getDirX();
        var dy = this.getDirY();
        var ax = dx.dot(p);
        var ay = dy.dot(p);
        var sx = this.size.x / 2;
        var sy = this.size.y / 2;
        if (ax >= -sx / 2 && ax <= sx && ay >= -sy && ay <= sy)
            return 0;
        if (ax < -sx) {
            if (ay <= -sy) {
                return MathUtil.getLength2D(-sx, -sy, ax, ay);
            }
            else if (ay >= sy) {
                return MathUtil.getLength2D(-sx, sy, ax, ay);
            }
            else {
                return -sx - ax;
            }
        }
        else if (ax > sx) {
            if (ay <= -sy) {
                return MathUtil.getLength2D(sx, -sy, ax, ay);
            }
            else if (ay >= sy) {
                return MathUtil.getLength2D(sx, sy, ax, ay);
            }
            else {
                return ax - sx;
            }
        }
        else {
            if (ay <= -sy) {
                return -sy - ay;
            }
            else if (ay >= sy) {
                return ay - sy;
            }
            else {
                return 0;
            }
        }
    }
    getPoints() {
        var sin = Math.sin(this.rotation);
        var cos = Math.cos(this.rotation);
        return [new Point2d(this.center.x + this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin + this.size.y / 2 * cos), new Point2d(this.center.x + this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y + this.size.x / 2 * sin - this.size.y / 2 * cos), new Point2d(this.center.x - this.size.x / 2 * cos + this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin - this.size.y / 2 * cos), new Point2d(this.center.x - this.size.x / 2 * cos - this.size.y / 2 * sin, this.center.y - this.size.x / 2 * sin + this.size.y / 2 * cos)];
    }
    save(savenode) {
        savenode.setName(KRotatedArea.GEOMNAME);
        ObjectFolder.addNodeDouble(savenode, "cx", this.center.x);
        ObjectFolder.addNodeDouble(savenode, "cy", this.center.y);
        ObjectFolder.addNodeDouble(savenode, "sx", this.size.x);
        ObjectFolder.addNodeDouble(savenode, "sy", this.size.y);
        ObjectFolder.addNodeDouble(savenode, "rot", this.rotation);
    }
    static readData(datanode, r) {
        var on;
        if ((on = datanode.getNode("cx")) != null)
            r.center.x = on.getDouble(0);
        if ((on = datanode.getNode("cy")) != null)
            r.center.y = on.getDouble(0);
        if ((on = datanode.getNode("sx")) != null)
            r.size.x = on.getDouble(0);
        if ((on = datanode.getNode("sy")) != null)
            r.size.y = on.getDouble(0);
        if ((on = datanode.getNode("rot")) != null)
            r.rotation = on.getDouble(0);
    }
    //hashCode() : number {
    //    var prime : number = 31;
    //    var result : number = 1;
    //    result = prime * result + ((this.center == null) ? 0 : this.center.hashCode());
    //    result = prime * result + Double.valueOf(this.rotation).hashCode();
    //    result = prime * result + ((this.size == null) ? 0 : this.size.hashCode());
    //    return result;
    //}
    equals(obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this.center == null) {
            if (other.center != null)
                return false;
        }
        else if (!this.center.equals(other.center))
            return false;
        if (this.rotation !== other.rotation)
            return false;
        if (this.size == null) {
            if (other.size != null)
                return false;
        }
        else if (!this.size.equals(other.size))
            return false;
        return true;
    }
}
//# sourceMappingURL=KRotatedArea.js.map