import { error } from '../common';
//module jp.kitec.kwt
export class KGradientFill {
    constructor(color, fractions) {
        if (color.length != fractions.length)
            throw new error.lang.IllegalArgumentException();
        this.mColor = color;
        this.mFractions = fractions;
    }
    get color() {
        return this.mColor;
    }
    get fractions() {
        return this.mFractions;
    }
    encode() {
        var sb = "";
        this.mColor.forEach(c => {
            sb += c.encode();
            sb += ",";
        });
        sb += ";";
        this.mFractions.forEach(d => {
            sb += d;
            sb += ",";
        });
        return sb;
    }
}
//# sourceMappingURL=KGradientFill.js.map