import { KFontMetrics } from './KFontMetrics';
/**
 * @author kawae
 **/
export declare abstract class KFont {
    /**
     * フォントタイプ**/
    static PLAIN: number;
    static BOLD: number;
    static ITALIC: number;
    /**
     * フォントオブジェクト
     **/
    private mFontname;
    private mFonttype;
    private mFontsize;
    constructor(fontname: string, fonttype: number, fontsize: number);
    name: string;
    style: number;
    size: number;
    abstract getFontMetrics(context: Object): KFontMetrics;
    abstract getFontObject(): Object;
    ascent: number;
    descent: number;
    height: number;
    stringWidth(s: string): number;
    /**
     * 現在の Font オブジェクトを複製し新しいサイズを適用することにより、新しい Font オブジェクトを生成します。
     * @param size
     * @return
    **/
    deriveSize(size: number): KFont;
    /**
     * 現在の Font オブジェクトを複製し新しいスタイルを適用することにより、新しい Font オブジェクトを生成します。
     * @param style
     * @return
    **/
    deriveStyle(style: number): KFont;
    /**
     * この Font オブジェクトを複製し新しいスタイルおよびサイズを適用することにより、新しい Font オブジェクトを生成します。
     * @param style
     * @param size
     * @return
    **/
    deriveStyleSize(style: number, size: number): KFont;
    hashCode(): number;
    equals(obj: KFont): boolean;
    static getFont(fontname: string, fontstyle: number, fontsize: number): KFont;
}
