import { ObjectFolder } from '../util/tree/ObjectFolder';
/**
 * 領域クラス
 * @author kawae
**/
export declare class KArea {
    static GEOMNAME: string;
    minX: number;
    minY: number;
    maxX: number;
    maxY: number;
    constructor(x1?: number, y1?: number, x2?: number, y2?: number);
    width(): number;
    height(): number;
    maximize(): void;
    setArea(x1: number, y1: number, x2: number, y2: number): void;
    setArea(a: KArea): void;
    updateMinMax(a: KArea): void;
    updateMinMax(x: number, y: number): void;
    updateMinMaxX(x: number): void;
    updateMinMaxY(y: number): void;
    isInner(x: number, y: number): boolean;
    distanceTo(x: number, y: number): number;
    equals(other: KArea): boolean;
    save(savenode: ObjectFolder): void;
    static readData(datanode: ObjectFolder, a: KArea): void;
}
